/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;

public class GroupedReminders
extends PatientReminders {
    private Party customer;
    private Contact contact;
    private Party location;
    private DocumentTemplate template;

    public GroupedReminders(ReminderType.GroupBy groupBy, boolean resend) {
        super(groupBy, resend);
    }

    public void setCustomer(Party customer) {
        this.customer = customer;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public void setLocation(Party location) {
        this.location = location;
    }

    public void setTemplate(DocumentTemplate template) {
        this.template = template;
    }

    public Party getCustomer() {
        return this.customer;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Party getLocation() {
        return this.location;
    }

    public DocumentTemplate getTemplate() {
        return this.template;
    }

    @Override
    public Context createContext(Party practice) {
        Context context = super.createContext(practice);
        context.setCustomer(this.customer);
        context.setLocation(this.location);
        List<ReminderEvent> reminders = this.getReminders();
        if (reminders.size() == 1 || this.getGroupBy() == ReminderType.GroupBy.PATIENT) {
            ReminderEvent reminder = reminders.get(0);
            context.setPatient(reminder.getPatient());
        }
        return context;
    }
}

