/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.processor.BatchProcessorDialog;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemBrowser;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemCRUDWindow;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemProgressBarProcessor;

class ErrorReminderItemCRUDWindow
extends ReminderItemCRUDWindow {
    private static final String RESOLVE_ID = "button.resolve";
    private static final String RESOLVE_ALL_ID = "button.resolveAll";

    public ErrorReminderItemCRUDWindow(ReminderItemBrowser browser, Context context, HelpContext help) {
        super(browser, true, context, help);
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(RESOLVE_ID, this::onResolve);
        buttons.add(RESOLVE_ALL_ID, this::onResolveAll);
        buttons.add(this.createCompleteButton());
        buttons.add(this.createCompleteAllButton());
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(RESOLVE_ID, enable);
    }

    private void onResolve() {
        Act object = (Act)this.getObject();
        Act item = (Act)IMObjectHelper.reload((IMObject)object);
        if (item != null && "ERROR".equals(item.getStatus())) {
            this.resolveError(item);
        }
        this.onRefresh(object);
    }

    private void onResolveAll() {
        ConfirmationDialog.show((String)Messages.get((String)"reporting.reminder.resolveall.prompt.title"), (String)Messages.get((String)"reporting.reminder.resolveall.prompt.message"), (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                ErrorReminderItemCRUDWindow.this.onResolveAllConfirmed();
            }
        });
    }

    private void onResolveAllConfirmed() {
        ReminderItemQueryFactory factory = this.getQueryFactory();
        if (factory != null) {
            ResolveAllProgressBarProcessor processor = new ResolveAllProgressBarProcessor(factory);
            BatchProcessorDialog dialog = new BatchProcessorDialog(Messages.get((String)"reporting.reminder.resolveall.run.title"), Messages.get((String)"reporting.reminder.resolveall.run.message"), (ProgressBarProcessor)processor, true, this.getHelpContext());
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    ErrorReminderItemCRUDWindow.this.onRefresh((Act)ErrorReminderItemCRUDWindow.this.getObject());
                }
            });
            dialog.show();
        } else {
            this.onRefresh((Act)this.getObject());
        }
    }

    private void resolveError(Act item) {
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setValue("status", (Object)"PENDING");
        bean.setValue("error", null);
        bean.save();
    }

    private class ResolveAllProgressBarProcessor
    extends ReminderItemProgressBarProcessor {
        public ResolveAllProgressBarProcessor(ReminderItemQueryFactory factory) {
            super(factory);
        }

        @Override
        protected void process(Act item, Act reminder) {
            String status = item.getStatus();
            if ("ERROR".equals(status)) {
                ErrorReminderItemCRUDWindow.this.resolveError(item);
                this.updated();
            }
        }
    }
}

