/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.component.processor.AbstractBatchProcessor;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderBatchProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemSource;
import org.openvpms.web.workspace.reporting.reminder.Statistics;

public abstract class AbstractReminderBatchProcessor<T extends PatientReminders>
extends AbstractBatchProcessor
implements ReminderBatchProcessor {
    private final ReminderItemSource query;
    private final PatientReminderProcessor<T> processor;
    private final String titleKey;
    private T current;
    private boolean resend = false;
    private boolean moreAvailable = false;
    private Statistics statistics;
    private static final int BATCH_SIZE = 1000;

    public AbstractReminderBatchProcessor(ReminderItemSource query, PatientReminderProcessor<T> processor, String titleKey) {
        this.query = query;
        this.processor = processor;
        this.titleKey = titleKey;
    }

    @Override
    public String getArchetype() {
        return this.processor.getArchetype();
    }

    public boolean getResend() {
        return this.resend;
    }

    @Override
    public void setResend(boolean resend) {
        this.resend = resend;
    }

    @Override
    public Component getComponent() {
        return null;
    }

    public String getTitle() {
        return Messages.get((String)this.titleKey);
    }

    @Override
    public boolean hasMoreReminders() {
        return this.moreAvailable;
    }

    @Override
    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    public void process() {
        block7: {
            this.current = null;
            Iterator<ReminderEvent> iterator = this.query.all();
            ArrayList<ReminderEvent> reminders = new ArrayList<ReminderEvent>();
            while ((this.moreAvailable = iterator.hasNext()) && reminders.size() < 1000) {
                reminders.add(iterator.next());
            }
            if (!reminders.isEmpty()) {
                try {
                    this.current = this.processor.prepare(reminders, ReminderType.GroupBy.NONE, new Date(), this.getResend());
                    if (((PatientReminders)this.current).canSend()) {
                        this.processor.process(this.current);
                        if (!this.processor.isAsynchronous()) {
                            this.completed();
                        }
                        break block7;
                    }
                    this.completed();
                }
                catch (Exception exception) {
                    this.notifyError(exception);
                }
            } else {
                this.notifyCompleted();
            }
        }
    }

    protected void completed() {
        this.updateReminders();
        this.notifyCompleted();
    }

    protected void notifyCompleted() {
        super.notifyCompleted();
    }

    protected void updateReminders() {
        if (this.current != null) {
            this.processor.complete(this.current);
            this.setProcessed(((PatientReminders)this.current).getProcessed());
            if (this.statistics != null) {
                this.processor.addStatistics((PatientReminders)this.current, this.statistics);
            }
        }
    }

    protected void notifyError(Throwable exception) {
        if (this.current != null) {
            this.processor.failed((PatientReminders)this.current, exception);
            if (this.statistics != null) {
                this.statistics.addErrors(((PatientReminders)this.current).getErrors().size());
            }
        }
        super.notifyError(exception);
    }
}

