/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.insurance;

import java.util.List;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.system.ServiceHelper;

public class ClaimTableModel
extends DescriptorTableModel<Act> {
    private final IArchetypeRuleService service = ServiceHelper.getArchetypeService();
    private final ArchetypeNodes nodes;
    private final InsuranceRules rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
    private int insurerIndex;
    private int customerIndex;
    private State state;

    public ClaimTableModel(LayoutContext context) {
        super(context);
        this.nodes = ArchetypeNodes.nodes((String[])new String[]{"id", "startTime", "patient", "location", "policy", "insurerId", "status", "amount", "gapClaim", "status2", "benefitAmount", "paid", "clinician"});
        this.setTableColumnModel(this.createColumnModel(new String[]{"act.patientInsuranceClaim"}, context));
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return this.nodes;
    }

    protected Object getValue(Act object, TableColumn column, int row) {
        Object result;
        LayoutContext layoutContext = this.getLayoutContext();
        if (column.getModelIndex() == this.customerIndex) {
            Reference customer = this.getState(object, row).customer;
            result = new IMObjectReferenceViewer(customer, layoutContext.getContextSwitchListener(), layoutContext.getContext()).getComponent();
        } else if (column.getModelIndex() == this.insurerIndex) {
            Reference insurer = this.getState(object, row).insurer;
            result = new IMObjectReferenceViewer(insurer, layoutContext.getContextSwitchListener(), layoutContext.getContext()).getComponent();
        } else {
            result = super.getValue((IMObject)object, column, row);
        }
        return result;
    }

    protected Object getValue(Act object, DescriptorTableColumn column, int row) {
        Object result = "policy".equals(column.getName()) ? this.getState(object, row).policyNumber : super.getValue((IMObject)object, column, row);
        return result;
    }

    protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(archetypes, context);
        DescriptorTableColumn policy = this.getColumn((TableColumnModel)model, "policy");
        if (policy != null) {
            policy.setHeaderValue((Object)this.getDisplayName("act.patientInsurancePolicy", "insurerId"));
        }
        this.customerIndex = this.getNextModelIndex((TableColumnModel)model);
        this.insurerIndex = this.customerIndex + 1;
        TableColumn customer = new TableColumn(this.customerIndex);
        TableColumn insurer = new TableColumn(this.insurerIndex);
        customer.setHeaderValue((Object)this.getDisplayName("act.patientInsurancePolicy", "customer"));
        insurer.setHeaderValue((Object)this.getDisplayName("act.patientInsurancePolicy", "insurer"));
        this.addColumnAfter(customer, this.getModelIndex((TableColumnModel)model, "startTime"), (TableColumnModel)model);
        this.addColumnAfter(insurer, this.getModelIndex((TableColumnModel)model, "location"), (TableColumnModel)model);
        return model;
    }

    private State getState(Act claim, int row) {
        if (this.state == null || row != this.state.row) {
            this.state = new State(claim, row);
        }
        return this.state;
    }

    private class State {
        private final String policyNumber;
        private final Reference customer;
        private final Reference insurer;
        private final int row;

        public State(Act claim, int row) {
            Act policy = (Act)ClaimTableModel.this.service.getBean((IMObject)claim).getTarget("policy", Act.class);
            if (policy != null) {
                this.policyNumber = ClaimTableModel.this.rules.getPolicyNumber(policy);
                IMObjectBean bean = ClaimTableModel.this.service.getBean((IMObject)policy);
                this.customer = bean.getTargetRef("customer");
                this.insurer = bean.getTargetRef("insurer");
            } else {
                this.policyNumber = null;
                this.customer = null;
                this.insurer = null;
            }
            this.row = row;
        }
    }
}

