/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.charge;

import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.account.AccountActActions;
import org.openvpms.web.workspace.customer.charge.ChargePoster;
import org.openvpms.web.workspace.customer.charge.PostedChargeWorkflow;
import org.openvpms.web.workspace.reporting.account.AccountActCRUDWindow;

public class IncompleteChargesCRUDWindow
extends AccountActCRUDWindow {
    private static final String POST_ID = "button.post";
    private static final String POST_TOPIC = "customer/charge/post";

    public IncompleteChargesCRUDWindow(Archetypes<FinancialAct> archetypes, QueryBrowser<FinancialAct> browser, Context context, HelpContext help) {
        super(archetypes, browser, "WORK_IN_PROGRESS_CHARGES", context, help);
        CustomerAccountRules rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
        AccountReminderRules reminderRules = (AccountReminderRules)ServiceHelper.getBean(AccountReminderRules.class);
        PracticeService practiceService = (PracticeService)ServiceHelper.getBean(PracticeService.class);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        this.setActions((IMObjectActions)new AccountActActions(rules, reminderRules, practiceService, (ArchetypeService)service));
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(POST_ID, this.action(this::onPost, true, null));
        buttons.add(this.createDeleteButton());
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(POST_ID, enable);
        buttons.setEnabled("button.delete", enable);
    }

    protected void onPost(FinancialAct object) {
        AccountActActions actions = this.getActions();
        if (actions.canPost(object)) {
            HelpContext help = this.getHelpContext().topic(POST_TOPIC);
            ChargePoster poster = new ChargePoster(object, actions, this.createLayoutContext(help));
            poster.post(charge -> {
                if ("POSTED".equals(charge.getStatus())) {
                    this.onPosted((FinancialAct)charge);
                } else {
                    this.onRefresh((IMObject)charge);
                }
            });
        } else {
            this.onRefresh((IMObject)object);
        }
    }

    protected void onPosted(final FinancialAct charge) {
        HelpContext help = this.getHelpContext().topic(POST_TOPIC);
        PostedChargeWorkflow workflow = new PostedChargeWorkflow(charge, this.getContext(), help);
        workflow.addTaskListener((TaskListener)new DefaultTaskListener(){

            public void taskEvent(TaskEvent event) {
                IncompleteChargesCRUDWindow.this.onRefresh((IMObject)charge);
            }
        });
        workflow.start();
    }

    protected AccountActActions getActions() {
        return (AccountActActions)super.getActions();
    }
}

