/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.account;

import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.BillingCustomerMailContext;

public class AccountActCRUDWindow
extends ResultSetCRUDWindow<FinancialAct> {
    private final QueryBrowser<FinancialAct> browser;
    private final String reportType;

    public AccountActCRUDWindow(Archetypes<FinancialAct> archetypes, QueryBrowser<FinancialAct> browser, String reportType, Context context, HelpContext help) {
        this(archetypes, Actions.INSTANCE, browser, reportType, context, help);
    }

    protected AccountActCRUDWindow(Archetypes<FinancialAct> archetypes, ActActions<FinancialAct> actions, QueryBrowser<FinancialAct> browser, String reportType, Context context, HelpContext help) {
        super(archetypes, actions, browser.getQuery(), null, (Context)LocalContext.copy((Context)context), help);
        Context local = this.getContext();
        local.setCustomer(null);
        local.setPatient(null);
        this.setMailContext((MailContext)new BillingCustomerMailContext(local, help));
        this.reportType = reportType;
        this.browser = browser;
    }

    public void setObject(FinancialAct object) {
        IMObjectBean bean;
        super.setObject((IMObject)object);
        Party customer = null;
        if (object != null && (bean = this.getBean((IMObject)object)).hasNode("customer")) {
            customer = (Party)bean.getTarget("customer", Party.class);
        }
        this.getContext().setCustomer(customer);
    }

    public Party getCustomer() {
        return this.getContext().getCustomer();
    }

    public void view() {
        this.setResultSet(this.browser.getResultSet());
        super.view();
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(this.createViewButton());
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        buttons.add("report", this::onReport);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        buttons.setEnabled("view", enable);
        buttons.setEnabled("button.print", enable);
        buttons.setEnabled("button.mail", enable);
    }

    private void onReport() {
        Context context = this.getContext();
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator(this.reportType, context);
        IMPrinterFactory printerFactory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
        IMObjectReportPrinter printer = printerFactory.createIMObjectReportPrinter((Iterable)this.getQuery(), (DocumentTemplateLocator)locator, context);
        InteractiveIMPrinter iPrinter = new InteractiveIMPrinter(Messages.get((String)"reporting.account.print"), (IMPrinter)printer, context, this.getHelpContext());
        iPrinter.setMailContext(this.getMailContext());
        iPrinter.print();
    }

    private static class Actions
    extends ActActions<FinancialAct> {
        public static final ActActions<FinancialAct> INSTANCE = new Actions();

        private Actions() {
        }

        public boolean canCreate() {
            return false;
        }

        public boolean canEdit(FinancialAct act) {
            return false;
        }

        public boolean canDelete(FinancialAct object) {
            return false;
        }
    }
}

