/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.AbstractWorkspace;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;

public abstract class AbstractReportingWorkspace<T extends IMObject>
extends AbstractWorkspace<T> {
    private final Class<T> type;
    private ButtonRow buttons;

    public AbstractReportingWorkspace(String id, Class<T> type, Context context, MailContext mailContext) {
        super(id, context);
        this.type = type;
        this.setMailContext(mailContext);
    }

    public void setObject(T object) {
        super.setObject(object);
        this.enableButtons(this.buttons.getButtons(), object != null);
    }

    protected Class<T> getType() {
        return this.type;
    }

    protected Component doLayout() {
        SplitPane root = SplitPaneFactory.create((int)5, (String)"SplitPaneWithButtonRow", (Component[])new Component[0]);
        Component heading = super.doLayout();
        root.add(heading);
        FocusGroup group = new FocusGroup("AbstractReportingWorkspace");
        this.buttons = new ButtonRow(group, "ControlRow", "default");
        this.layoutButtons(this.buttons.getButtons());
        this.enableButtons(this.buttons.getButtons(), false);
        SplitPane content = SplitPaneFactory.create((int)6, (String)"SplitPaneWithButtonRow", (Component[])new Component[]{this.buttons});
        this.doLayout((Component)content, group);
        root.add((Component)content);
        return root;
    }

    protected void doLayout(Component container, FocusGroup group) {
    }

    protected ButtonSet getButtons() {
        return this.buttons.getButtons();
    }

    protected void layoutButtons(ButtonSet buttons) {
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
    }
}

