/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import java.math.BigDecimal;
import java.util.List;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.edit.act.ActItemEditor;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class StockTransferItemEditor
extends ActItemEditor {
    private final SimpleProperty fromQuantity;
    private final SimpleProperty toQuantity;
    private final StockRules rules = (StockRules)ServiceHelper.getBean(StockRules.class);
    private Party transferFrom;
    private Party transferTo;

    public StockTransferItemEditor(Act act, Act parent, LayoutContext context) {
        super(act, parent, context);
        this.fromQuantity = new SimpleProperty("fromQuantity", BigDecimal.class);
        this.fromQuantity.setDisplayName(Messages.get((String)"product.stock.fromQuantity"));
        this.fromQuantity.setValue((Object)BigDecimal.ZERO);
        this.fromQuantity.setReadOnly(true);
        this.toQuantity = new SimpleProperty("toQuantity", BigDecimal.class);
        this.toQuantity.setDisplayName(Messages.get((String)"product.stock.toQuantity"));
        this.toQuantity.setValue((Object)BigDecimal.ZERO);
        this.toQuantity.setReadOnly(true);
        if (parent != null) {
            IMObjectBean bean = this.getBean((IMObject)parent);
            this.setTransferFrom((Party)this.getObject(bean.getTargetRef("stockLocation")));
            this.setTransferTo((Party)this.getObject(bean.getTargetRef("to")));
        }
    }

    public void setTransferFrom(Party location) {
        this.transferFrom = location;
        this.updateFromQuantity(this.getProduct());
    }

    public void setTransferTo(Party location) {
        this.transferTo = location;
        this.updateToQuantity(this.getProduct());
    }

    protected void productModified(Product product) {
        this.updateFromQuantity(product);
        this.updateToQuantity(product);
        this.notifyProductListener(product);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new ActItemEditor.LayoutStrategy(){

            protected ComponentSet createComponentSet(IMObject object, List<Property> properties, LayoutContext context) {
                ComponentSet set = super.createComponentSet(object, properties, context);
                ComponentState from = this.createComponent((Property)StockTransferItemEditor.this.fromQuantity, object, context);
                ComponentState to = this.createComponent((Property)StockTransferItemEditor.this.toQuantity, object, context);
                set.add(from);
                set.add(to);
                return set;
            }
        };
    }

    private void updateFromQuantity(Product product) {
        this.fromQuantity.setValue((Object)this.getStock(product, this.transferFrom));
    }

    private void updateToQuantity(Product product) {
        this.toQuantity.setValue((Object)this.getStock(product, this.transferTo));
    }

    private BigDecimal getStock(Product product, Party stockLocation) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            if (product != null && stockLocation != null) {
                result = this.rules.getStock(product, stockLocation);
            }
        }
        catch (OpenVPMSException error) {
            ErrorHelper.show((Throwable)error);
        }
        return result;
    }
}

