/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.lookup.ArchetypeLookupQuery;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.query.AbstractEntityQuery;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.workspace.product.stock.StockExportResultSet;

public class StockExportObjectSetQuery
extends AbstractEntityQuery<ObjectSet> {
    private Party stockLocation;
    private Entity productType;
    private String incomeType;
    private String productGroup;
    private final CheckBox zeroNegativeQuantities;
    private static final String[] SHORT_NAMES = new String[]{"product.medication", "product.merchandise"};

    public StockExportObjectSetQuery() {
        this(null);
    }

    public StockExportObjectSetQuery(Party stockLocation) {
        super(SHORT_NAMES, ObjectSet.class);
        this.setStockLocation(stockLocation);
        this.zeroNegativeQuantities = CheckBoxFactory.create((String)"product.stock.export.zeroNegativeQuantities", (boolean)true);
    }

    public void setStockLocation(Party stockLocation) {
        this.stockLocation = stockLocation;
    }

    public Party getStockLocation() {
        return this.stockLocation;
    }

    public void setProductType(Entity type) {
        this.productType = type;
    }

    public void setProductGroup(String productGroup) {
        this.productGroup = productGroup;
    }

    public void setIncomeType(String incomeType) {
        this.incomeType = incomeType;
    }

    public boolean getZeroNegativeQuantities() {
        return this.zeroNegativeQuantities.isSelected();
    }

    public ResultSet<ObjectSet> query(SortConstraint[] sort) {
        if (this.stockLocation != null) {
            return super.query(sort);
        }
        return null;
    }

    public Extent getHeight() {
        return this.getHeight(3);
    }

    protected Component createContainer() {
        return GridFactory.create((int)8);
    }

    protected void doLayout(Component container) {
        super.doLayout(container);
        this.addProductTypeSelector(container);
        this.addStockLocationSelector(container);
        this.addIncomeTypeSelector(container);
        this.addProductGroupSelector(container);
        container.add((Component)this.zeroNegativeQuantities);
    }

    protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
        return new StockExportResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), (Entity)this.stockLocation, this.productType, this.incomeType, this.productGroup, sort, this.getMaxResults());
    }

    private void addStockLocationSelector(Component container) {
        final SelectField field = this.createObjectSelector("party.organisationStockLocation", false, (IMObject)this.stockLocation);
        if (this.stockLocation == null) {
            this.setStockLocation((Party)field.getSelectedItem());
        }
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StockExportObjectSetQuery.this.setStockLocation((Party)field.getSelectedItem());
            }
        });
        Label label = LabelFactory.create((String)"product.stockLocation");
        container.add((Component)label);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private void addProductTypeSelector(Component container) {
        final SelectField field = this.createObjectSelector("entity.productType", true, (IMObject)this.productType);
        if (this.productType == null) {
            this.setProductType((Entity)field.getSelectedItem());
        }
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StockExportObjectSetQuery.this.setProductType((Entity)field.getSelectedItem());
            }
        });
        Label label = LabelFactory.create((String)"product.export.productType");
        container.add((Component)label);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private void addIncomeTypeSelector(Component container) {
        final SelectField field = this.createLookupSelector("lookup.productIncomeType", this.incomeType);
        if (this.incomeType == null) {
            this.setIncomeType((String)field.getSelectedItem());
        }
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StockExportObjectSetQuery.this.setProductGroup((String)field.getSelectedItem());
            }
        });
        Label label = LabelFactory.create((String)"product.export.incomeType");
        container.add((Component)label);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private void addProductGroupSelector(Component container) {
        final SelectField field = this.createLookupSelector("lookup.productGroup", this.productGroup);
        if (this.productGroup == null) {
            this.setProductGroup((String)field.getSelectedItem());
        }
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StockExportObjectSetQuery.this.setProductGroup((String)field.getSelectedItem());
            }
        });
        Label label = LabelFactory.create((String)"product.export.productGroup");
        container.add((Component)label);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private SelectField createObjectSelector(String shortName, boolean all, IMObject defaultValue) {
        ArchetypeQuery query = new ArchetypeQuery(shortName, true).add((IConstraint)Constraints.sort((String)"name")).setMaxResults(-1);
        IMObjectListModel model = new IMObjectListModel(QueryHelper.query((ArchetypeQuery)query), all, false);
        SelectField field = SelectFieldFactory.create((ListModel)model);
        field.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        if (defaultValue != null) {
            field.setSelectedItem((Object)defaultValue);
        }
        return field;
    }

    private SelectField createLookupSelector(String shortName, String defaultValue) {
        ArchetypeLookupQuery query = new ArchetypeLookupQuery(shortName);
        SelectField field = SelectFieldFactory.create((ListModel)new LookupListModel((LookupQuery)query, true), (Object)defaultValue);
        field.setCellRenderer((ListCellRenderer)LookupListCellRenderer.INSTANCE);
        return field;
    }
}

