/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import java.sql.Date;
import java.util.Iterator;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.stock.io.StockCSVWriter;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.archetype.rules.util.FileNameHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.product.stock.StockExportBrowser;
import org.openvpms.web.workspace.product.stock.StockExportQuery;
import org.openvpms.web.workspace.product.stock.StockIOHelper;

public class StockExportDialog
extends BrowserDialog<StockData> {
    private static final String EXPORT_ID = "button.export";
    private static final String[] BUTTONS = new String[]{"button.export", "close"};
    private final char separator;

    public StockExportDialog(LayoutContext context, HelpContext help) {
        super(Messages.get((String)"product.stock.export.title"), BUTTONS, false, help);
        this.separator = StockIOHelper.getFieldSeparator(context.getContext().getPractice());
        this.init((Browser)new StockExportBrowser(context), null);
        this.setCloseOnSelection(false);
    }

    protected void onButton(String button) {
        if (EXPORT_ID.equals(button)) {
            try {
                this.onExport();
            }
            catch (Throwable exception) {
                ErrorHandler.getInstance().error(exception);
            }
        } else {
            super.onButton(button);
        }
    }

    private void onExport() {
        StockExportQuery query = ((StockExportBrowser)this.getBrowser()).getQuery();
        Party stockLocation = query.getStockLocation();
        if (stockLocation != null) {
            StockCSVWriter exporter = new StockCSVWriter((DocumentHandlers)ServiceHelper.getBean(DocumentHandlers.class), this.separator);
            String name = "stock-" + FileNameHelper.clean((String)stockLocation.getName()) + "-" + new Date(System.currentTimeMillis()) + ".csv";
            Document document = exporter.write(name, (Iterator)new ResultSetIterator(query.query()));
            DownloadServlet.startDownload((org.openvpms.component.model.document.Document)document);
        }
    }
}

