/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.io;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.layout.GridLayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.table.PagedIMTableModel;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.product.io.ProductImportExportTableModel;
import org.openvpms.web.workspace.product.io.ProductPriceData;

public class ProductImportDialog
extends PopupDialog {
    private final ProductPriceRules rules;

    public ProductImportDialog(List<ProductData> data, HelpContext help) {
        super(Messages.get((String)"product.import.title"), "ProductImportExportDialog", OK_CANCEL, help);
        this.setModal(true);
        this.rules = (ProductPriceRules)ServiceHelper.getBean(ProductPriceRules.class);
        ListResultSet resultSet = new ListResultSet(data, 20);
        PagedProductDataTableModel model = new PagedProductDataTableModel();
        PagedIMTable table = new PagedIMTable((IMTableModel)model, (ResultSet)resultSet);
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{table.getComponent()}));
    }

    protected void onOK() {
        ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)"product.import.title"), Messages.get((String)"product.import.save"));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                ProductImportDialog.super.onOK();
            }
        });
        dialog.show();
    }

    private class ProductPriceDataModel
    extends ProductImportExportTableModel<ProductPriceData> {
        private static final String LINE_THROUGH = "italicLineThrough";

        private ProductPriceDataModel() {
        }

        protected Object getValue(ProductPriceData object, TableColumn column, int row) {
            String result;
            boolean first = row == 0 || ((ProductPriceData)this.getObjects().get(row - 1)).getProductData().getId() != object.getProductData().getId();
            PriceData fixedPrice = object.getFixedPrice();
            PriceData unitPrice = object.getUnitPrice();
            switch (column.getModelIndex()) {
                case 0: {
                    result = first ? Long.valueOf(object.getProductData().getId()) : null;
                    break;
                }
                case 1: {
                    result = first ? object.getProductData().getName() : null;
                    break;
                }
                case 2: {
                    result = first ? this.getPrintedName(object) : null;
                    break;
                }
                case 3: {
                    result = fixedPrice != null ? this.getPrice(object, fixedPrice) : null;
                    break;
                }
                case 4: {
                    result = fixedPrice != null ? this.getCost(object, fixedPrice) : null;
                    break;
                }
                case 5: {
                    result = fixedPrice != null ? this.getMaxDiscount(object, fixedPrice) : null;
                    break;
                }
                case 6: {
                    result = fixedPrice != null ? this.getFromDate(object, fixedPrice) : null;
                    break;
                }
                case 7: {
                    result = fixedPrice != null ? this.getToDate(object, fixedPrice) : null;
                    break;
                }
                case 8: {
                    result = fixedPrice != null ? this.getPricingGroups(object, fixedPrice) : null;
                    break;
                }
                case 9: {
                    result = unitPrice != null ? this.getPrice(object, unitPrice) : null;
                    break;
                }
                case 10: {
                    result = unitPrice != null ? this.getCost(object, unitPrice) : null;
                    break;
                }
                case 11: {
                    result = unitPrice != null ? this.getMaxDiscount(object, unitPrice) : null;
                    break;
                }
                case 12: {
                    result = unitPrice != null ? this.getFromDate(object, unitPrice) : null;
                    break;
                }
                case 13: {
                    result = unitPrice != null ? this.getToDate(object, unitPrice) : null;
                    break;
                }
                case 14: {
                    result = unitPrice != null ? this.getPricingGroups(object, unitPrice) : null;
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }

        private Object getPrice(ProductPriceData object, PriceData price) {
            ProductPrice current = this.getProductPrice(object, price);
            if (current != null) {
                return this.getValue(current.getPrice(), price.getPrice());
            }
            return this.getValue(price.getPrice(), price.getPrice());
        }

        private Object getCost(ProductPriceData object, PriceData price) {
            ProductPrice current = this.getProductPrice(object, price);
            if (current != null) {
                IMObjectBean bean = this.getBean((IMObject)current);
                BigDecimal oldValue = bean.getBigDecimal("cost");
                return this.getValue(oldValue, price.getCost());
            }
            return this.getValue(price.getCost(), price.getCost());
        }

        private Object getMaxDiscount(ProductPriceData object, PriceData price) {
            ProductPrice current = this.getProductPrice(object, price);
            if (current != null) {
                IMObjectBean bean = this.getBean((IMObject)current);
                BigDecimal oldValue = bean.getBigDecimal("maxDiscount");
                return this.getValue(oldValue, price.getMaxDiscount());
            }
            return this.getValue(price.getMaxDiscount(), price.getMaxDiscount());
        }

        private Object getFromDate(ProductPriceData object, PriceData price) {
            ProductPrice current = this.getProductPrice(object, price);
            if (current != null) {
                Date oldValue = current.getFromDate();
                return this.getValue(this.formatDate(oldValue), this.formatDate(price.getFrom()));
            }
            return this.getValue(this.formatDate(price.getFrom()), this.formatDate(price.getFrom()));
        }

        private Object getToDate(ProductPriceData object, PriceData price) {
            ProductPrice current = this.getProductPrice(object, price);
            if (current != null) {
                Date oldValue = current.getToDate();
                return this.getValue(this.formatDate(oldValue), this.formatDate(price.getTo()));
            }
            return this.getValue(this.formatDate(price.getTo()), this.formatDate(price.getTo()));
        }

        private Component getPricingGroups(ProductPriceData object, PriceData price) {
            HashSet<Lookup> oldValue;
            ProductPrice current = this.getProductPrice(object, price);
            Set newValue = price.getPricingGroups();
            Object result = current != null ? (!(oldValue = new HashSet<Lookup>(ProductImportDialog.this.rules.getPricingGroups(current))).equals(newValue) ? this.getOldAndNewValueGrid((Component)this.getPricingGroups(oldValue, LINE_THROUGH), (Component)this.getPricingGroups(newValue, "default")) : this.getPricingGroups(newValue, "default")) : this.getPricingGroups(newValue, "default");
            return result;
        }

        private ProductPrice getProductPrice(ProductPriceData object, PriceData price) {
            Product product;
            ProductPrice result = null;
            if (price.getId() != -1L && (product = object.getProduct()) != null) {
                for (ProductPrice productPrice : product.getProductPrices()) {
                    if (productPrice.getId() != price.getId()) continue;
                    result = productPrice;
                    break;
                }
            }
            return result;
        }

        private Object getPrintedName(ProductPriceData object) {
            String oldValue = null;
            String newValue = object.getProductData().getPrintedName();
            Product product = object.getProduct();
            if (product != null) {
                IMObjectBean bean = this.getBean((IMObject)product);
                oldValue = bean.getString("printedName");
            }
            if (!Objects.equals(oldValue, newValue)) {
                Label oldLabel = this.createOldValueLabel(oldValue);
                Label newLabel = this.createNewValueLabel(newValue);
                return ColumnFactory.create((Component[])new Component[]{oldLabel, newLabel});
            }
            return newValue;
        }

        private Object getValue(Object oldValue, Object newValue) {
            Label result;
            boolean equals = oldValue instanceof BigDecimal && newValue instanceof BigDecimal ? ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0 : Objects.equals(oldValue, newValue);
            if (!equals) {
                GridLayoutData oldLayout = new GridLayoutData();
                oldLayout.setAlignment(Alignment.ALIGN_RIGHT);
                oldLayout.setInsets(new Insets(0, 0, 5, 0));
                Label oldLabel = this.createOldValueLabel(oldValue);
                oldLabel.setLayoutData((LayoutData)oldLayout);
                GridLayoutData newLayout = new GridLayoutData();
                newLayout.setAlignment(Alignment.ALIGN_RIGHT);
                Label newLabel = this.createNewValueLabel(newValue);
                newLabel.setLayoutData((LayoutData)newLayout);
                result = this.getOldAndNewValueGrid((Component)oldLabel, (Component)newLabel);
            } else {
                result = newValue instanceof BigDecimal ? this.rightAlign((BigDecimal)newValue) : this.rightAlign(newValue);
            }
            return result;
        }

        private Grid getOldAndNewValueGrid(Component oldValue, Component newValue) {
            Grid grid = new Grid(2);
            grid.setWidth(Styles.FULL_WIDTH);
            grid.setColumnWidth(0, new Extent(50, 2));
            grid.setColumnWidth(1, new Extent(50, 2));
            grid.add(oldValue);
            grid.add(newValue);
            TableLayoutData layoutData = new TableLayoutData();
            layoutData.setAlignment(Alignment.ALIGN_RIGHT);
            grid.setLayoutData((LayoutData)layoutData);
            return grid;
        }

        private Label createNewValueLabel(Object newValue) {
            return this.createLabel(newValue);
        }

        private Label createOldValueLabel(Object oldValue) {
            Label oldLabel = this.createLabel(oldValue);
            oldLabel.setStyleName(LINE_THROUGH);
            return oldLabel;
        }

        private Label createLabel(Object newValue) {
            Label newLabel = new Label();
            newLabel.setText(newValue != null ? newValue.toString() : Messages.get((String)"product.import.novalue"));
            return newLabel;
        }
    }

    private class PagedProductDataTableModel
    extends PagedIMTableModel<ProductData, ProductPriceData> {
        public PagedProductDataTableModel() {
            super((IMTableModel)new ProductPriceDataModel());
        }

        protected List<ProductPriceData> convertTo(List<ProductData> list) {
            ArrayList<ProductPriceData> result = new ArrayList<ProductPriceData>();
            for (ProductData product : list) {
                List fixedPrices = product.getFixedPrices();
                List unitPrices = product.getUnitPrices();
                int count = Math.max(fixedPrices.size(), unitPrices.size());
                if (count == 0) {
                    count = 1;
                }
                for (int i = 0; i < count; ++i) {
                    PriceData fixedPrice = i < fixedPrices.size() ? (PriceData)fixedPrices.get(i) : null;
                    PriceData unitPrice = i < unitPrices.size() ? (PriceData)unitPrices.get(i) : null;
                    ProductPriceData data = new ProductPriceData(product, fixedPrice, unitPrice);
                    result.add(data);
                }
            }
            return result;
        }
    }
}

