/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.filetransfer.UploadListener;
import nextapp.echo2.app.list.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.io.ProductCSVReader;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductDataFilter;
import org.openvpms.archetype.rules.product.io.ProductDataSet;
import org.openvpms.archetype.rules.product.io.ProductImporter;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.InventoryService;
import org.openvpms.smartflow.client.SyncState;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.product.io.ProductExportDialog;
import org.openvpms.web.workspace.product.io.ProductImportDialog;
import org.openvpms.web.workspace.product.io.ProductImportErrorDialog;

public class ProductCRUDWindow
extends ResultSetCRUDWindow<Product> {
    private final IArchetypeService service = ServiceHelper.getArchetypeService();
    private final FlowSheetServiceFactory flowSheetServiceFactory;
    private final UserRules rules = (UserRules)ServiceHelper.getBean(UserRules.class);
    static final String COPY_ID = "copy";
    static final String EXPORT_ID = "button.export";
    static final String IMPORT_ID = "button.import";
    static final String SYNCH_ID = "button.synchwithsfs";

    public ProductCRUDWindow(Archetypes<Product> archetypes, Query<Product> query, ResultSet<Product> set, Context context, HelpContext help) {
        super(archetypes, query, set, context, help);
        this.flowSheetServiceFactory = this.getFlowSheetServiceFactory();
    }

    protected FlowSheetServiceFactory getFlowSheetServiceFactory() {
        return (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
    }

    protected void layoutButtons(ButtonSet buttons) {
        User user = this.getContext().getUser();
        boolean edit = false;
        boolean remove = false;
        if (user != null) {
            edit = this.rules.canEdit(user, "product.*");
            remove = this.rules.canRemove(user, "product.*");
        }
        if (edit) {
            buttons.add(this.createNewButton());
        }
        buttons.add(this.createViewButton());
        if (edit) {
            buttons.add(this.createEditButton());
        }
        if (remove) {
            buttons.add(this.createDeleteButton());
        }
        if (edit) {
            buttons.add(COPY_ID, this::onCopy);
        }
        if (edit && remove) {
            buttons.add(EXPORT_ID, this::onExport);
            buttons.add(IMPORT_ID, this::onImport);
            Party location = this.getContext().getLocation();
            if (location != null && this.flowSheetServiceFactory.isSmartFlowSheetEnabled(location)) {
                buttons.add(SYNCH_ID, this::onSynchronise);
            }
        }
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        buttons.setEnabled("view", this.getResultSet() != null && enable);
        buttons.setEnabled("button.edit", enable);
        buttons.setEnabled("button.delete", enable);
        buttons.setEnabled(COPY_ID, enable);
    }

    protected void onCopy() {
        final Product product = (Product)IMObjectHelper.reload((IMObject)this.getObject());
        if (product != null) {
            String displayName = this.getArchetypeDescriptor().getDisplayName();
            String name = product.getName();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = displayName;
            }
            String title = Messages.format((String)"product.information.copy.title", (Object[])new Object[]{displayName});
            String message = Messages.format((String)"product.information.copy.message", (Object[])new Object[]{name});
            HelpContext help = this.getHelpContext().subtopic(COPY_ID);
            ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (HelpContext)help, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    ProductCRUDWindow.this.copy(product);
                }
            });
        }
    }

    protected void onSynchronise() {
        HelpContext help = this.getHelpContext().subtopic("sync");
        ConfirmationDialog.show((String)Messages.get((String)"product.information.sync.title"), (String)Messages.get((String)"product.information.sync.message"), (String[])ConfirmationDialog.YES_NO, (HelpContext)help, (WindowPaneListener)new PopupDialogListener(){

            public void onYes() {
                ProductCRUDWindow.this.synchroniseProducts();
            }
        });
    }

    private void copy(Product product) {
        try {
            String copyName;
            ProductRules rules = (ProductRules)ServiceHelper.getBean(ProductRules.class);
            String name = product.getName();
            IMObjectBean bean = this.service.getBean((IMObject)product);
            int length = bean.getMaxLength("name");
            if (length <= 0) {
                length = 255;
            }
            if ((copyName = Messages.format((String)"product.copy.name", (Object[])new Object[]{name})).length() > length) {
                name = StringUtils.abbreviate((String)name, (int)(length - (copyName.length() - length)));
                copyName = Messages.format((String)"product.copy.name", (Object[])new Object[]{name});
            }
            Product copy = rules.copy(product, copyName);
            HelpContext edit = this.createEditTopic((IMObject)product);
            LayoutContext context = this.createLayoutContext(edit);
            IMObjectEditor editor = this.createEditor((IMObject)copy, context);
            this.edit(editor);
        }
        catch (OpenVPMSException exception) {
            String title = Messages.format((String)"product.information.copy.failed", (Object[])new Object[]{this.getArchetypeDescriptor().getDisplayName()});
            ErrorHelper.show((String)title, (Throwable)exception);
        }
    }

    private void synchroniseProducts() {
        Party location = this.getContext().getLocation();
        Party stockLocation = this.getContext().getStockLocation();
        Party practice = this.getContext().getPractice();
        boolean useLocationProducts = practice != null && this.service.getBean((IMObject)practice).getBoolean("useLocationProducts");
        InventoryService service = this.flowSheetServiceFactory.getInventoryService(location);
        SyncState sync = service.synchronise(useLocationProducts, location, stockLocation);
        String title = Messages.get((String)"product.information.sync.title");
        String message = sync.changed() ? Messages.get((String)"product.information.sync.updated") : Messages.get((String)"product.information.sync.noupdate");
        InformationDialog.show((String)title, (String)message);
    }

    private void onExport() {
        HelpContext help = this.getHelpContext().subtopic("export");
        ProductExportDialog dialog = new ProductExportDialog(this.createLayoutContext(help), help);
        dialog.show();
    }

    private void onImport() {
        final HelpContext help = this.getHelpContext().subtopic("import");
        DocumentUploadListener listener = new DocumentUploadListener(){

            protected void upload(Document document) {
                try {
                    ProductCRUDWindow.this.importDocument(document, help);
                }
                catch (Throwable exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            }
        };
        UploadDialog dialog = new UploadDialog((UploadListener)listener, help.subtopic("upload"));
        dialog.show();
    }

    private void importDocument(Document document, HelpContext help) {
        ProductCSVReader reader = new ProductCSVReader((DocumentHandlers)ServiceHelper.getBean(DocumentHandlers.class), ServiceHelper.getLookupService());
        List formats = reader.getDateFormats(document);
        boolean ambiguousDates = false;
        if (formats.size() > 1) {
            List<SimpleDateFormat> dmy = this.getFormats(formats, ProductCSVReader.getDayMonthYearFormats());
            List<SimpleDateFormat> mdy = this.getFormats(formats, ProductCSVReader.getMonthDayYearFormats());
            List<SimpleDateFormat> ymd = this.getFormats(formats, ProductCSVReader.getYearMonthDayFormats());
            ArrayList<List<SimpleDateFormat>> formatList = new ArrayList<List<SimpleDateFormat>>();
            if (!dmy.isEmpty()) {
                formatList.add(dmy);
            }
            if (!mdy.isEmpty()) {
                formatList.add(mdy);
            }
            if (!ymd.isEmpty()) {
                formatList.add(ymd);
            }
            if (formatList.size() > 1) {
                ambiguousDates = true;
                this.selectDateFormatAndImport(document, formatList, reader, help);
            }
        }
        if (!ambiguousDates) {
            reader.setDateFormats(formats);
            this.importDocument(document, reader, help);
        }
    }

    private void importDocument(Document document, ProductCSVReader reader, HelpContext help) {
        ProductDataSet data = reader.read(document);
        if (data.getErrors().isEmpty()) {
            ProductDataFilter filter = new ProductDataFilter((ProductPriceRules)ServiceHelper.getBean(ProductPriceRules.class), this.service);
            data = filter.filter(data.getData());
        }
        if (data.getErrors().isEmpty()) {
            final List output = data.getData();
            if (!output.isEmpty()) {
                ProductImportDialog dialog = new ProductImportDialog(output, help);
                dialog.show();
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        ProductCRUDWindow.this.onImport(output);
                    }
                });
            } else {
                InformationDialog.show((String)Messages.get((String)"product.import.title"), (String)Messages.get((String)"product.import.nochanges"));
            }
        } else {
            List errors = data.getErrors();
            ProductImportErrorDialog dialog = new ProductImportErrorDialog(errors, help.subtopic("errors"));
            dialog.show();
        }
    }

    private void selectDateFormatAndImport(final Document document, List<List<SimpleDateFormat>> formatList, final ProductCSVReader reader, final HelpContext help) {
        final DateFormatDialog dialog = new DateFormatDialog(formatList, help.subtopic("date"));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                reader.setDateFormats(dialog.getDateFormats());
                ProductCRUDWindow.this.importDocument(document, reader, help);
            }
        });
        dialog.show();
    }

    private List<SimpleDateFormat> getFormats(List<SimpleDateFormat> matches, List<SimpleDateFormat> formats) {
        ArrayList<SimpleDateFormat> result = new ArrayList<SimpleDateFormat>();
        for (SimpleDateFormat match : matches) {
            for (SimpleDateFormat format : formats) {
                if (match != format) continue;
                result.add(match);
            }
        }
        return result;
    }

    private void onImport(List<ProductData> data) {
        ProductImporter importer = new ProductImporter((ProductPriceRules)ServiceHelper.getBean(ProductPriceRules.class), this.service);
        importer.run(data);
        InformationDialog.show((String)Messages.get((String)"product.import.title"), (String)Messages.get((String)"product.import.imported"));
    }

    static class DateFormatDialog
    extends MessageDialog {
        private final SelectField field;

        public DateFormatDialog(List<List<SimpleDateFormat>> formats, HelpContext help) {
            super(Messages.get((String)"product.import.dateformat.title"), Messages.get((String)"product.import.dateformat.message"), OK_CANCEL, help);
            this.field = SelectFieldFactory.create(formats);
            this.field.setCellRenderer(new ListCellRenderer(){

                public Object getListCellRendererComponent(Component list, Object value, int index) {
                    List formats = (List)value;
                    return ((SimpleDateFormat)formats.get(0)).toPattern().toLowerCase();
                }
            });
        }

        public List<SimpleDateFormat> getDateFormats() {
            return (List)this.field.getSelectedItem();
        }

        protected void doLayout() {
            Label message = LabelFactory.create();
            message.setText(this.getMessage());
            Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, this.field});
            Row row = RowFactory.create((String)"Inset.Large", (Component[])new Component[]{column});
            this.getLayout().add((Component)row);
        }
    }
}

