/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.visit;

import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.history.PatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;
import org.openvpms.web.workspace.patient.visit.AbstractVisitHistoryBrowserCRUDWindow;
import org.openvpms.web.workspace.patient.visit.VisitCRUDWindow;

public class VisitHistoryBrowserCRUDWindow
extends AbstractVisitHistoryBrowserCRUDWindow {
    private final HelpContext help;
    private Act event;

    public VisitHistoryBrowserCRUDWindow(PatientHistoryQuery query, PatientHistoryBrowser browser, Context context, HelpContext help) {
        this.help = help;
        if (browser.getSelected() == null) {
            browser.query();
            List objects = browser.getObjects();
            if (!objects.isEmpty()) {
                browser.setSelected((Act)objects.get(0));
            }
        }
        this.setBrowser((Browser)browser);
        PatientHistoryCRUDWindow window = this.createWindow(context);
        window.setQuery(query);
        window.setEvent(browser.getSelectedParent());
        this.setWindow(window);
    }

    public void setEvent(Act event) {
        this.event = event;
    }

    public void setSelected(Act object) {
        super.setSelected((IMObject)object);
        this.getWindow().setEvent(this.getBrowser().getSelectedParent());
    }

    @Override
    public PatientHistoryBrowser getBrowser() {
        return (PatientHistoryBrowser)super.getBrowser();
    }

    @Override
    public void show() {
        PatientHistoryBrowser browser = this.getBrowser();
        if (browser.getObjects().contains(this.event)) {
            Act selected = (Act)browser.getSelected();
            browser.query();
            if (selected != null) {
                browser.setSelected(selected);
            }
        }
        browser.setFocusOnResults();
    }

    protected PatientHistoryCRUDWindow createWindow(Context context) {
        return new VisitCRUDWindow(context, this.help);
    }

    protected void select(Act object) {
        super.select((IMObject)object);
        PatientHistoryBrowser browser = this.getBrowser();
        AbstractPatientHistoryCRUDWindow window = this.getWindow();
        window.setEvent(browser.getEvent(object));
    }
}

