/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.visit;

import echopointng.TabbedPane;
import echopointng.model.SingleSelectionModel;
import echopointng.tabbedpane.TabModel;
import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.retry.AbstractRetryable;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.button.ShortcutHelper;
import org.openvpms.web.echo.event.VetoListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.echo.tabpane.VetoableSingleSelectionModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.charge.VisitChargeEditor;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.history.PatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;
import org.openvpms.web.workspace.patient.mr.PatientDocumentQuery;
import org.openvpms.web.workspace.patient.problem.ProblemBrowser;
import org.openvpms.web.workspace.patient.problem.ProblemQuery;
import org.openvpms.web.workspace.patient.problem.ProblemRecordCRUDWindow;
import org.openvpms.web.workspace.patient.visit.AlertBrowserCRUDWindow;
import org.openvpms.web.workspace.patient.visit.EstimateBrowserCRUDWindow;
import org.openvpms.web.workspace.patient.visit.PrescriptionBrowserCRUDWindow;
import org.openvpms.web.workspace.patient.visit.ReminderBrowserCRUDWindow;
import org.openvpms.web.workspace.patient.visit.VisitBrowserCRUDWindow;
import org.openvpms.web.workspace.patient.visit.VisitChargeCRUDWindow;
import org.openvpms.web.workspace.patient.visit.VisitDocumentCRUDWindow;
import org.openvpms.web.workspace.patient.visit.VisitEditorListener;
import org.openvpms.web.workspace.patient.visit.VisitEditorTab;
import org.openvpms.web.workspace.patient.visit.VisitHistoryBrowserCRUDWindow;
import org.openvpms.web.workspace.patient.visit.VisitProblemBrowserCRUDWindow;

public class VisitEditor {
    public static final int HISTORY_TAB = 0;
    public static final int PROBLEM_TAB = 1;
    public static final int INVOICE_TAB = 2;
    public static final int REMINDER_TAB = 3;
    public static final int ALERT_TAB = 4;
    public static final int DOCUMENT_TAB = 5;
    public static final int PRESCRIPTION_TAB = 6;
    public static final int ESTIMATE_TAB = 7;
    private final VisitHistoryBrowserCRUDWindow historyWindow;
    private final Act event;
    private final PatientHistoryQuery query;
    private final Context context;
    private final HelpContext help;
    private final Preferences preferences;
    private final VisitChargeCRUDWindow chargeWindow;
    private final Party patient;
    private final VisitBrowserCRUDWindow<Act> reminderWindow;
    private final VisitBrowserCRUDWindow<Act> alertWindow;
    private final VisitBrowserCRUDWindow<DocumentAct> documentWindow;
    private final PrescriptionBrowserCRUDWindow prescriptionWindow;
    private final EstimateBrowserCRUDWindow estimateWindow;
    private final FocusGroup focusGroup = new FocusGroup(this.getClass().getName());
    private VisitProblemBrowserCRUDWindow problemWindow;
    private VisitEditorListener listener;
    private Component container;
    private TabbedPane tabbedPane;

    public VisitEditor(Party customer, Party patient, Act event, FinancialAct invoice, Context context, HelpContext help) {
        this.patient = patient;
        this.event = event;
        this.context = context;
        this.help = help;
        this.preferences = ServiceHelper.getPreferences();
        this.query = new PatientHistoryQuery(patient, this.preferences);
        this.query.setAllDates(true);
        this.query.setFrom(event.getActivityStartTime());
        this.query.setTo(DateRules.getDate((Date)event.getActivityStartTime(), (int)1, (DateUnits)DateUnits.DAYS));
        boolean showProblems = this.showProblems(context);
        ContextSwitchListener listener = null;
        if (showProblems) {
            listener = new ContextSwitchListener(){

                public void switchTo(IMObject object) {
                    VisitEditor.this.followHyperlink(object);
                }

                public void switchTo(String shortName) {
                }
            };
        }
        this.historyWindow = this.createHistoryBrowserCRUDWindow(context, listener);
        this.historyWindow.setEvent(event);
        this.historyWindow.setSelected(event);
        if (showProblems) {
            this.problemWindow = this.createProblemBrowserCRUDWindow(context, listener);
        }
        this.chargeWindow = this.createVisitChargeCRUDWindow(event, context);
        this.chargeWindow.setObject(invoice);
        this.reminderWindow = this.createReminderCRUDWindow(context);
        this.alertWindow = this.createAlertCRUDWindow(context);
        this.documentWindow = this.createDocumentBrowserCRUDWindow(context);
        this.prescriptionWindow = this.createPrescriptionCRUDWindow(context);
        this.estimateWindow = this.createEstimateBrowserCRUDWindow(customer, patient, context, help);
    }

    public Act getEvent() {
        return this.event;
    }

    public PatientHistoryBrowser getHistoryBrowser() {
        return this.historyWindow.getBrowser();
    }

    public AbstractPatientHistoryCRUDWindow getHistoryWindow() {
        return this.historyWindow.getWindow();
    }

    public ProblemBrowser getProblemBrowser() {
        return this.problemWindow != null ? this.problemWindow.getBrowser() : null;
    }

    public ProblemRecordCRUDWindow getProblemWindow() {
        return this.problemWindow != null ? this.problemWindow.getWindow() : null;
    }

    public VisitChargeCRUDWindow getCharge() {
        return this.chargeWindow;
    }

    public VisitChargeEditor getChargeEditor() {
        return this.chargeWindow.getEditor();
    }

    public void selectCharges() {
        this.selectTab(2);
    }

    public int getSelectedTab() {
        int index = this.tabbedPane.getSelectedIndex();
        return index != -1 ? this.getModelIndex(index) : -1;
    }

    public void setButtons(ButtonSet buttons) {
        CRUDWindow<? extends Act> window = this.getWindow(this.tabbedPane.getSelectedIndex());
        if (window instanceof AbstractCRUDWindow) {
            ((AbstractCRUDWindow)window).setButtons(buttons);
        }
    }

    public PatientHistoryQuery getQuery() {
        return this.query;
    }

    public void setListener(VisitEditorListener listener) {
        this.listener = listener;
    }

    public HelpContext getHelpContext() {
        HelpContext result = this.getBaseHelpContext();
        CRUDWindow<? extends Act> window = this.getWindow(this.tabbedPane.getSelectedIndex());
        if (window != null) {
            result = window.getHelpContext();
        }
        return result;
    }

    public Component getComponent() {
        if (this.container == null) {
            this.container = ColumnFactory.create((String)"InsetY");
            ObjectTabPaneModel model = new ObjectTabPaneModel(this.container);
            this.addTabs((ObjectTabPaneModel<VisitEditorTab>)model);
            this.tabbedPane = TabbedPaneFactory.create((TabModel)model);
            this.tabbedPane.setStyleName("VisitEditor.TabbedPane");
            VetoableSingleSelectionModel selectionModel = new VetoableSingleSelectionModel();
            this.tabbedPane.setSelectionModel((SingleSelectionModel)selectionModel);
            selectionModel.setVetoListener((VetoListener)new VetoListener<VetoableSingleSelectionModel.Change>(){

                public void onVeto(VetoableSingleSelectionModel.Change change) {
                    change.veto(!VisitEditor.this.switchTabs(change.getOldIndex(), change.getNewIndex()));
                }
            });
            this.tabbedPane.getSelectionModel().addChangeListener((ChangeListener)new org.openvpms.web.echo.event.ChangeListener(){

                public void onChange(ChangeEvent event) {
                    VisitEditor.this.onTabSelected(VisitEditor.this.tabbedPane.getSelectedIndex());
                }
            });
            this.focusGroup.add((Component)this.tabbedPane);
            this.container.add((Component)this.tabbedPane);
            this.tabbedPane.setSelectedIndex(0);
            this.historyWindow.getBrowser().setFocusOnResults();
        }
        return this.container;
    }

    public boolean save() {
        boolean saved = this.chargeWindow.save();
        if (saved) {
            this.updateVisitStatus();
        }
        return saved;
    }

    public boolean saveAsInProgress() {
        boolean saved = this.chargeWindow.inProgress();
        if (saved) {
            this.updateVisitStatus();
        }
        return saved;
    }

    public boolean saveAsCompleted() {
        boolean saved = this.chargeWindow.complete();
        if (saved) {
            this.updateVisitStatus();
        }
        return saved;
    }

    public Party getPatient() {
        return this.patient;
    }

    protected Context getContext() {
        return this.context;
    }

    protected HelpContext getBaseHelpContext() {
        return this.help;
    }

    protected void selectTab(int index) {
        this.tabbedPane.setSelectedIndex(this.getTabIndex(index));
    }

    protected CRUDWindow<? extends Act> getWindow(int index) {
        VisitEditorTab tab = this.getVisitEditorTab(index);
        return tab != null ? tab.getWindow() : null;
    }

    protected int getModelIndex(int tabIndex) {
        VisitEditorTab tab = this.getVisitEditorTab(tabIndex);
        return tab != null ? tab.getId() : -1;
    }

    protected int getTabIndex(int modelIndex) {
        ObjectTabPaneModel<VisitEditorTab> model = this.getModel();
        for (int i = 0; i < model.size(); ++i) {
            VisitEditorTab tab = (VisitEditorTab)model.getObject(i);
            if (tab == null || tab.getId() != modelIndex) continue;
            return i;
        }
        return -1;
    }

    protected VisitHistoryBrowserCRUDWindow createHistoryBrowserCRUDWindow(Context context, ContextSwitchListener listener) {
        DefaultLayoutContext layout = new DefaultLayoutContext(context, this.help.subtopic("summary"));
        layout.setContextSwitchListener(listener);
        VisitHistoryBrowserCRUDWindow result = new VisitHistoryBrowserCRUDWindow(this.query, new PatientHistoryBrowser(this.query, (LayoutContext)layout), context, layout.getHelpContext());
        result.setId(0);
        return result;
    }

    protected boolean showProblems(Context context) {
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)context.getPractice());
        return bean.getBoolean("showProblemsInVisit");
    }

    protected VisitProblemBrowserCRUDWindow createProblemBrowserCRUDWindow(Context context, ContextSwitchListener listener) {
        ProblemQuery query = new ProblemQuery(this.patient, this.preferences);
        DefaultLayoutContext layout = new DefaultLayoutContext(context, this.help);
        layout.setContextSwitchListener(listener);
        ProblemBrowser browser = new ProblemBrowser(query, (LayoutContext)layout);
        VisitProblemBrowserCRUDWindow result = new VisitProblemBrowserCRUDWindow(browser, new ProblemRecordCRUDWindow(context, this.help));
        result.setId(1);
        return result;
    }

    protected VisitChargeCRUDWindow createVisitChargeCRUDWindow(Act event, Context context) {
        VisitChargeCRUDWindow result = new VisitChargeCRUDWindow(event, context, this.help.subtopic("invoice"));
        result.setId(2);
        return result;
    }

    protected ReminderBrowserCRUDWindow createReminderCRUDWindow(Context context) {
        ReminderBrowserCRUDWindow result = new ReminderBrowserCRUDWindow(this.patient, context, this.help.subtopic("reminder"));
        result.setId(3);
        return result;
    }

    protected AlertBrowserCRUDWindow createAlertCRUDWindow(Context context) {
        AlertBrowserCRUDWindow result = new AlertBrowserCRUDWindow(this.patient, context, this.help.subtopic("alert"));
        result.setId(4);
        return result;
    }

    protected VisitBrowserCRUDWindow<DocumentAct> createDocumentBrowserCRUDWindow(Context context) {
        PatientDocumentQuery query = new PatientDocumentQuery(this.patient);
        Browser browser = BrowserFactory.create(query, (LayoutContext)new DefaultLayoutContext(context, this.help));
        VisitDocumentCRUDWindow window = new VisitDocumentCRUDWindow(context, this.help.subtopic("document"));
        VisitBrowserCRUDWindow<DocumentAct> result = new VisitBrowserCRUDWindow<DocumentAct>((Browser<DocumentAct>)browser, (AbstractCRUDWindow<DocumentAct>)window);
        result.setId(5);
        return result;
    }

    protected PrescriptionBrowserCRUDWindow createPrescriptionCRUDWindow(Context context) {
        PrescriptionBrowserCRUDWindow result = new PrescriptionBrowserCRUDWindow(this.patient, context, this.help.subtopic("prescription"));
        result.setVisitEditor(this);
        result.setId(6);
        return result;
    }

    protected EstimateBrowserCRUDWindow createEstimateBrowserCRUDWindow(Party customer, Party patient, Context context, HelpContext help) {
        EstimateBrowserCRUDWindow result = new EstimateBrowserCRUDWindow(customer, patient, this, context, help.subtopic("estimate"));
        result.setId(7);
        return result;
    }

    protected void addTabs(ObjectTabPaneModel<VisitEditorTab> model) {
        this.addPatientHistoryTab(model);
        if (this.problemWindow != null) {
            this.addProblemTab(model);
        }
        this.addInvoiceTab(model);
        this.addRemindersTab(model);
        this.addAlertsTab(model);
        this.addDocumentsTab(model);
        this.addPrescriptionsTab(model);
        this.addEstimatesTab(model);
    }

    protected void addTab(String button, ObjectTabPaneModel<VisitEditorTab> model, VisitEditorTab tab, int id) {
        int index = model.size();
        int shortcut = index + 1;
        String text = "&" + shortcut + " " + ShortcutHelper.getText((String)Messages.get((String)button));
        model.addTab((Object)tab, text, tab.getComponent());
        tab.setId(id);
    }

    protected void onTabSelected(int selected) {
        ObjectTabPaneModel<VisitEditorTab> model = this.getModel();
        VisitEditorTab tab = (VisitEditorTab)model.getObject(selected);
        if (tab != null) {
            tab.show();
            this.notifyListener(tab.getId());
        }
    }

    protected VisitEditorTab getVisitEditorTab(int index) {
        return (VisitEditorTab)this.getModel().getObject(index);
    }

    protected ObjectTabPaneModel<VisitEditorTab> getModel() {
        return (ObjectTabPaneModel)this.tabbedPane.getModel();
    }

    protected void notifyListener(int index) {
        if (this.listener != null) {
            this.listener.selected(index);
        }
    }

    protected void addPatientHistoryTab(ObjectTabPaneModel<VisitEditorTab> model) {
        this.addTab("button.summary", model, this.historyWindow, 0);
    }

    protected void addProblemTab(ObjectTabPaneModel<VisitEditorTab> model) {
        this.addTab("button.problem", model, this.problemWindow, 1);
    }

    protected void addInvoiceTab(ObjectTabPaneModel<VisitEditorTab> model) {
        this.addTab("button.invoice", model, this.chargeWindow, 2);
    }

    protected void addRemindersTab(ObjectTabPaneModel<VisitEditorTab> model) {
        this.addTab("button.reminder", model, this.reminderWindow, 3);
    }

    protected void addAlertsTab(ObjectTabPaneModel<VisitEditorTab> model) {
        this.addTab("button.alert", model, this.alertWindow, 4);
    }

    protected void addDocumentsTab(ObjectTabPaneModel<VisitEditorTab> model) {
        this.addTab("button.document", model, this.documentWindow, 5);
    }

    protected void addPrescriptionsTab(ObjectTabPaneModel<VisitEditorTab> model) {
        this.addTab("button.prescriptions", model, this.prescriptionWindow, 6);
    }

    protected void addEstimatesTab(ObjectTabPaneModel<VisitEditorTab> model) {
        this.addTab("button.estimates", model, this.estimateWindow, 7);
    }

    protected EstimateBrowserCRUDWindow getEstimateWindow() {
        return this.estimateWindow;
    }

    protected boolean switchTabs(int oldIndex, int newIndex) {
        VisitEditorTab tab = this.getVisitEditorTab(oldIndex);
        return tab == null || tab.save();
    }

    protected void followHyperlink(IMObject object) {
        if (TypeHelper.isA((IMObject)object, (String)"act.patientClinicalProblem") && this.problemWindow != null) {
            this.selectTab(1);
            ProblemBrowser browser = this.problemWindow.getBrowser();
            browser.setSelected((Act)object, true);
        } else if (TypeHelper.isA((IMObject)object, (String)"act.patientClinicalEvent")) {
            this.selectTab(0);
            this.getHistoryBrowser().setSelected((Act)object, true);
        }
    }

    private void updateVisitStatus() {
        Retryer.run((Retryable)new VisitStatusUpdater());
    }

    private class VisitStatusUpdater
    extends AbstractRetryable {
        private VisitStatusUpdater() {
        }

        protected boolean runAction() {
            Act act = (Act)IMObjectHelper.reload((IMObject)VisitEditor.this.event);
            return act != null && this.updateStatus(act);
        }

        private boolean updateStatus(Act event) {
            String status = ((FinancialAct)VisitEditor.this.chargeWindow.getObject()).getStatus();
            String newStatus = null;
            if ("ON_HOLD".equals(status) || "IN_PROGRESS".equals(status)) {
                newStatus = "IN_PROGRESS";
            } else if ("POSTED".equals(status) || "COMPLETED".equals(status)) {
                newStatus = "COMPLETED";
            }
            if (newStatus != null && !status.equals(event.getStatus())) {
                event.setStatus(newStatus);
                ServiceHelper.getArchetypeService().save((IMObject)event);
            }
            return true;
        }
    }
}

