/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.problem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryFilter;

public class ProblemFilter
extends AbstractPatientHistoryFilter {
    private final Predicate<Act> search;
    private final ArchetypeService service;

    public ProblemFilter(String[] archetypes, Predicate<Act> search, boolean ascending, ArchetypeService service) {
        super("act.patientClinicalProblem", archetypes, Collections.emptyList());
        this.search = search;
        this.service = service;
        this.setSortItemsAscending(ascending);
    }

    public Comparator<Act> getComparator(Act act) {
        if (act.isA(new String[]{"act.patientMedication", "act.patientClinicalNote"})) {
            return super.getComparator(true);
        }
        return super.getComparator(act);
    }

    protected List<Act> filter(Act parent, List<Act> children, Map<Reference, Act> acts) {
        List<Act> result;
        if (this.search == null) {
            result = children;
        } else {
            result = new ArrayList<Act>();
            for (Act act : children) {
                if (!act.isA("act.patientClinicalEvent") && !this.search.test(act)) continue;
                result.add(act);
            }
        }
        return result;
    }

    @Override
    protected Set<Act> getChildren(Act act, Map<Reference, Act> acts) {
        Set<Act> children = super.getChildren(act, acts);
        if (act.isA("act.patientClinicalProblem")) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            Set events = this.getActs(bean.getSourceRefs("events"), acts);
            children.addAll(events);
        }
        return children;
    }
}

