/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderCount;
import org.openvpms.archetype.rules.patient.reminder.ReminderProcessor;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.sms.SMSHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.reminder.ReminderGenerator;
import org.openvpms.web.workspace.reporting.reminder.ReminderGeneratorFactory;

class ResendReminderDialog
extends PopupDialog {
    private final Act reminder;
    private final Context context;
    private final ReminderRules rules;
    private final ReminderProcessor processor;
    private final SelectField countSelector;
    private final SelectField contactSelector;
    private static final String ERROR_TITLE = "patient.reminder.resend.error.title";

    private ResendReminderDialog(Act reminder, List<Contact> contacts, List<Integer> reminderCounts, int reminderCount, ReminderProcessor processor, Context context, HelpContext help) {
        super(Messages.get((String)"patient.reminder.resend.title"), OK_CANCEL, help);
        this.reminder = reminder;
        this.processor = processor;
        this.context = context;
        this.rules = (ReminderRules)ServiceHelper.getBean(ReminderRules.class);
        this.setModal(true);
        Grid grid = GridFactory.create((int)2);
        grid.add((Component)LabelFactory.create((String)"patient.reminder.resend.contacts"));
        IMObjectListModel model = new IMObjectListModel(contacts, false, false);
        this.contactSelector = SelectFieldFactory.create((ListModel)model);
        this.contactSelector.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.DESCRIPTION);
        this.contactSelector.setSelectedIndex(0);
        grid.add((Component)this.contactSelector);
        grid.add((Component)LabelFactory.create((String)"patient.reminder.resend.reminderCount"));
        this.countSelector = SelectFieldFactory.create(reminderCounts);
        this.countSelector.setSelectedItem((Object)reminderCount);
        if (this.countSelector.getSelectedIndex() < 0) {
            this.countSelector.setSelectedIndex(0);
        }
        grid.add((Component)this.countSelector);
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{grid}));
    }

    public static ResendReminderDialog create(Act reminder, Context context, HelpContext help) {
        ResendReminderDialog result = null;
        ReminderConfiguration reminderConfig = ResendReminderDialog.getReminderConfig(context);
        if (reminderConfig == null) {
            ErrorHelper.show((String)Messages.get((String)ERROR_TITLE), (String)Messages.get((String)"patient.reminder.resend.noconfig"));
        } else {
            IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)reminder);
            int reminderCount = bean.getInt("reminderCount");
            PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
            boolean disableSMS = !SMSHelper.isSMSEnabled((Party)context.getPractice());
            try {
                ReminderProcessor processor = new ReminderProcessor(reminder.getActivityStartTime(), reminderConfig, disableSMS, (IArchetypeService)ServiceHelper.getArchetypeService(), rules);
                Party patient = processor.getPatient(reminder);
                if (patient == null) {
                    throw new IllegalStateException("Patient not found");
                }
                Party customer = processor.getCustomer(patient);
                if (customer != null) {
                    List<Contact> contacts = ResendReminderDialog.getContacts(customer, disableSMS);
                    if (!contacts.isEmpty()) {
                        ReminderType reminderType = processor.getReminderType(reminder);
                        List<Integer> counts = ResendReminderDialog.getReminderCounts(reminderType, reminderCount);
                        if (!counts.isEmpty()) {
                            result = new ResendReminderDialog(reminder, contacts, counts, reminderCount, processor, context, help);
                        } else {
                            ErrorHelper.show((String)Messages.get((String)ERROR_TITLE), (String)Messages.format((String)"patient.reminder.resend.notemplates", (Object[])new Object[]{reminderType.getName(), reminderCount}));
                        }
                    } else {
                        ErrorHelper.show((String)Messages.get((String)ERROR_TITLE), (String)Messages.get((String)"patient.reminder.resend.nocontacts"));
                    }
                } else {
                    ErrorHelper.show((String)Messages.get((String)ERROR_TITLE), (String)Messages.get((String)"patient.reminder.resend.nocustomer"));
                }
            }
            catch (Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
        return result;
    }

    protected void onOK() {
        Integer count = (Integer)this.countSelector.getSelectedItem();
        Contact contact = (Contact)this.contactSelector.getSelectedItem();
        if (count != null && contact != null) {
            this.generate(count, contact);
        }
    }

    protected static ReminderConfiguration getReminderConfig(Context context) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        IMObjectBean bean = service.getBean((IMObject)context.getPractice());
        IMObject config = bean.getTarget("reminderConfiguration", IMObject.class);
        return config != null ? new ReminderConfiguration(config, (ArchetypeService)service) : null;
    }

    private static List<Contact> getContacts(Party customer, boolean excludeSMS) {
        ArrayList<Contact> result = new ArrayList<Contact>();
        for (Contact contact : customer.getContacts()) {
            IMObjectBean bean;
            if (contact.isA(new String[]{"contact.location", "contact.email"})) {
                result.add(contact);
                continue;
            }
            if (excludeSMS || !contact.isA("contact.phoneNumber") || !(bean = ServiceHelper.getArchetypeService().getBean((IMObject)contact)).getBoolean("sms")) continue;
            result.add(contact);
        }
        return result;
    }

    private static List<Integer> getReminderCounts(ReminderType reminderType, int reminderCount) {
        ReminderCount count;
        int value;
        ArrayList<Integer> result = new ArrayList<Integer>();
        Iterator iterator = reminderType.getReminderCounts().iterator();
        while (iterator.hasNext() && (value = (count = (ReminderCount)iterator.next()).getCount()) < reminderCount) {
            if (count.getTemplate() == null) continue;
            result.add(value);
        }
        return result;
    }

    private void generate(int reminderCount, Contact contact) {
        Act item = this.rules.getReminderItem(this.reminder, reminderCount, contact);
        if (item == null) {
            item = this.processor.process(this.reminder, reminderCount, contact);
            item.setActivityStartTime(new Date());
        }
        this.generate(item, contact);
    }

    private void generate(final Act item, Contact contact) {
        ReminderGeneratorFactory factory = (ReminderGeneratorFactory)ServiceHelper.getBean(ReminderGeneratorFactory.class);
        Party location = this.context.getLocation();
        Party practice = this.context.getPractice();
        ReminderGenerator generator = factory.create(item, this.reminder, contact, location, practice, this.getHelpContext());
        generator.setResend(true);
        generator.setListener(new BatchProcessorListener(){

            public void completed() {
                if (item.isNew() && "CANCELLED".equals(item.getStatus())) {
                    IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)item);
                    ErrorHelper.show((String)Messages.get((String)ResendReminderDialog.ERROR_TITLE), (String)bean.getString("error"));
                }
                ResendReminderDialog.this.close();
            }

            public void error(Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        });
        generator.process();
    }
}

