/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.List;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ActCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.mr.ReminderActions;
import org.openvpms.web.workspace.patient.mr.ResendReminderDialog;

public class ReminderCRUDWindow
extends ActCRUDWindow<Act> {
    private static final String RESEND_ID = "resend";

    public ReminderCRUDWindow(Context context, HelpContext help) {
        super(Archetypes.create((String)"act.patientReminder", Act.class), (ActActions)ReminderActions.getInstance(), context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(RESEND_ID, this::onResend);
    }

    protected void delete(Act object) {
        IMObjectBean bean = this.getBean((IMObject)object);
        List items = bean.getTargets("items", Act.class);
        boolean sent = false;
        for (Act item : items) {
            if (!"COMPLETED".equals(item.getStatus())) continue;
            sent = true;
            break;
        }
        if (!sent) {
            super.delete((IMObject)object);
        } else {
            String displayName = IMObjectHelper.getName((Reference)bean.getTargetRef("reminderType"));
            if (displayName == null) {
                displayName = bean.getDisplayName();
            }
            String title = Messages.format((String)"patient.reminder.cannotdelete", (Object[])new Object[]{displayName});
            if ("CANCELLED".equals(object.getStatus())) {
                ((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().title(title)).message(Messages.format((String)"patient.reminder.cannotdelete.cancelled", (Object[])new Object[]{displayName}))).show();
            } else {
                ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(title)).message(Messages.format((String)"patient.reminder.cannotdelete.sent", (Object[])new Object[]{displayName}))).yesNo()).yes(() -> {
                    object.setStatus("CANCELLED");
                    bean.save();
                    this.onRefresh((IMObject)object);
                })).show();
            }
        }
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        boolean enableResend = false;
        if (enable) {
            enableResend = this.getActions().canResendReminder((Act)this.getObject());
        }
        buttons.setEnabled(RESEND_ID, enableResend);
    }

    protected ReminderActions getActions() {
        return (ReminderActions)super.getActions();
    }

    private void onResend() {
        try {
            HelpContext help = this.getHelpContext().subtopic(RESEND_ID);
            ResendReminderDialog dialog = ResendReminderDialog.create((Act)this.getObject(), this.getContext(), help);
            if (dialog != null) {
                dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                    public void onClose(WindowPaneEvent event) {
                        ReminderCRUDWindow.this.onRefresh(ReminderCRUDWindow.this.getObject());
                    }
                });
                dialog.show();
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }
}

