/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.DefaultActQuery;
import org.openvpms.web.component.im.query.DefaultIMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.TabbedBrowser;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.alert.AlertTableModel;
import org.openvpms.web.workspace.patient.communication.PatientCommunicationCRUDWindow;
import org.openvpms.web.workspace.patient.communication.PatientCommunicationQuery;
import org.openvpms.web.workspace.patient.estimate.PatientEstimateCRUDWindow;
import org.openvpms.web.workspace.patient.estimate.PatientEstimateQuery;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;
import org.openvpms.web.workspace.patient.insurance.InsuranceBrowser;
import org.openvpms.web.workspace.patient.insurance.InsuranceCRUDWindow;
import org.openvpms.web.workspace.patient.insurance.InsuranceQuery;
import org.openvpms.web.workspace.patient.mr.AlertCRUDWindow;
import org.openvpms.web.workspace.patient.mr.ChargesActTableModel;
import org.openvpms.web.workspace.patient.mr.ChargesCRUDWindow;
import org.openvpms.web.workspace.patient.mr.PatientAlertQuery;
import org.openvpms.web.workspace.patient.mr.PatientDocumentCRUDWindow;
import org.openvpms.web.workspace.patient.mr.PatientDocumentQuery;
import org.openvpms.web.workspace.patient.mr.PatientPrescriptionCRUDWindow;
import org.openvpms.web.workspace.patient.mr.PatientPrescriptionQuery;
import org.openvpms.web.workspace.patient.mr.ReminderActTableModel;
import org.openvpms.web.workspace.patient.mr.ReminderCRUDWindow;
import org.openvpms.web.workspace.patient.problem.ProblemBrowser;
import org.openvpms.web.workspace.patient.problem.ProblemQuery;
import org.openvpms.web.workspace.patient.problem.ProblemRecordCRUDWindow;

public class RecordBrowser
extends TabbedBrowser<Act> {
    private final Archetypes<DocumentAct> docArchetypes = Archetypes.create((String[])PatientDocumentQuery.DOCUMENT_SHORT_NAMES, DocumentAct.class, (String)Messages.get((String)"patient.document.createtype"));
    private final Archetypes<Act> prescriptionArchetypes = Archetypes.create((String)"act.patientPrescription", Act.class);
    private final PatientHistoryBrowser history;
    private final ProblemBrowser problems;
    private final Browser<Act> communication;
    private final int historyIndex;
    private final int problemIndex;
    private final int remindersIndex;
    private final int alertsIndex;
    private final int documentsIndex;
    private final int chargesIndex;
    private final int prescriptionIndex;
    private final int estimateIndex;
    private final int communicationIndex;
    private final int insuranceIndex;
    private static final String[] CHARGES_SHORT_NAMES = new String[]{"act.customerAccountInvoiceItem", "act.customerAccountCreditItem"};
    private static final SortConstraint[] DEFAULT_SORT = new SortConstraint[]{new NodeSortConstraint("startTime", false)};
    private static final ActStatuses REMINDER_STATUSES = new ActStatuses("act.patientReminder");
    private static final ActStatuses PROBLEM_STATUSES = new ActStatuses("act.patientClinicalProblem");

    public RecordBrowser(Party patient, PatientHistoryQuery query, Context context, HelpContext help) {
        DefaultLayoutContext layout = new DefaultLayoutContext(context, help);
        layout.setContextSwitchListener(new ContextSwitchListener(){

            public void switchTo(IMObject object) {
                RecordBrowser.this.followHyperlink(object);
            }

            public void switchTo(String shortName) {
            }
        });
        this.history = this.createHistoryBrowser(query, (LayoutContext)layout);
        this.historyIndex = this.addBrowser(Messages.get((String)"button.summary"), (Browser)this.history);
        this.problems = this.createProblemBrowser(patient, (LayoutContext)layout);
        this.problemIndex = this.addBrowser(Messages.get((String)"button.problem"), (Browser)this.problems);
        this.remindersIndex = this.addBrowser(Messages.get((String)"button.reminder"), this.createReminderBrowser(patient, (LayoutContext)layout));
        this.alertsIndex = this.addBrowser(Messages.get((String)"button.alert"), this.createAlertBrowser(patient, (LayoutContext)layout));
        this.documentsIndex = this.addBrowser(Messages.get((String)"button.document"), this.createDocumentBrowser(patient, (LayoutContext)layout));
        this.chargesIndex = this.addBrowser(Messages.get((String)"button.charges"), this.createChargeBrowser(patient, (LayoutContext)layout));
        this.prescriptionIndex = this.addBrowser(Messages.get((String)"button.prescriptions"), this.createPrescriptionBrowser(patient, (LayoutContext)layout));
        this.estimateIndex = this.addBrowser(Messages.get((String)"button.estimates"), this.createEstimateBrowser(patient, (LayoutContext)layout));
        this.communication = this.createCommunicationBrowser(patient, context, help);
        this.communicationIndex = this.addBrowser(Messages.get((String)"button.communication"), this.communication);
        this.insuranceIndex = this.addBrowser(Messages.get((String)"button.insurance"), this.createInsuranceBrowser(patient, context, help.subtopic("insurance")));
    }

    public void showHistory() {
        this.setSelectedBrowser(this.historyIndex);
    }

    public void showProblems() {
        this.setSelectedBrowser(this.problemIndex);
    }

    public void showInsurance() {
        this.setSelectedBrowser(this.insuranceIndex);
    }

    public CRUDWindow<Act> createCRUDWindow(Context context, HelpContext help) {
        int index = this.getSelectedBrowserIndex();
        Object result = index == this.problemIndex ? this.createProblemRecordCRUDWindow(context, help) : (index == this.remindersIndex ? this.createReminderCRUDWindow(context, help) : (index == this.alertsIndex ? this.createAlertCRUDWindow(context, help) : (index == this.documentsIndex ? this.createDocumentCRUDWindow(context, help) : (index == this.chargesIndex ? this.createChargesCRUDWindow(context, help) : (index == this.prescriptionIndex ? this.createPrescriptionCRUDWindow(context, help) : (index == this.estimateIndex ? this.createEstimateCRUDWindow(context, help) : (index == this.communicationIndex ? new PatientCommunicationCRUDWindow(context, help) : (index == this.insuranceIndex ? new InsuranceCRUDWindow(context, help.subtopic("insurance")) : this.createHistoryCRUDWindow(context, help)))))))));
        return result;
    }

    public Act getEvent(Act act) {
        int index = this.getSelectedBrowserIndex();
        AbstractPatientHistoryBrowser browser = index == this.historyIndex ? this.history : (index == this.problemIndex ? this.problems : null);
        if (browser != null) {
            if (act == null) {
                act = (Act)browser.getSelected();
            }
            return browser.getEvent(act);
        }
        return null;
    }

    public PatientHistoryBrowser getHistory() {
        return this.history;
    }

    public ProblemBrowser getProblems() {
        return this.problems;
    }

    protected PatientHistoryBrowser createHistoryBrowser(PatientHistoryQuery query, LayoutContext layout) {
        return new PatientHistoryBrowser(query, layout);
    }

    protected CRUDWindow<Act> createHistoryCRUDWindow(Context context, HelpContext help) {
        PatientHistoryCRUDWindow result = new PatientHistoryCRUDWindow(context, help);
        result.setQuery(this.history.getQuery());
        result.setEvent(this.getEvent(null));
        return result;
    }

    protected ProblemBrowser createProblemBrowser(Party patient, LayoutContext layout) {
        ProblemQuery query = new ProblemQuery(patient, layout.getPreferences());
        return new ProblemBrowser(query, layout);
    }

    protected CRUDWindow<Act> createProblemRecordCRUDWindow(Context context, HelpContext help) {
        ProblemRecordCRUDWindow result = new ProblemRecordCRUDWindow(context, help);
        result.setEvent(this.getEvent(null));
        result.setQuery(this.problems.getQuery());
        return result;
    }

    protected Browser<Act> createReminderBrowser(Party patient, LayoutContext layout) {
        DefaultActQuery query = new DefaultActQuery((Entity)patient, "patient", "participation.patient", "act.patientReminder", REMINDER_STATUSES);
        query.setStatus("IN_PROGRESS");
        query.setDefaultSortConstraint(DEFAULT_SORT);
        ReminderActTableModel model = new ReminderActTableModel(query.getShortNames(), layout);
        return new DefaultIMObjectTableBrowser((Query)query, (IMTableModel)model, layout);
    }

    protected CRUDWindow<Act> createReminderCRUDWindow(Context context, HelpContext help) {
        return new ReminderCRUDWindow(context, help);
    }

    protected Browser<Act> createAlertBrowser(Party patient, LayoutContext layout) {
        PatientAlertQuery query = new PatientAlertQuery(patient);
        AlertTableModel model = new AlertTableModel(query.getShortNames(), layout);
        return new DefaultIMObjectTableBrowser((Query)query, (IMTableModel)model, layout);
    }

    protected CRUDWindow<Act> createAlertCRUDWindow(Context context, HelpContext help) {
        return new AlertCRUDWindow(context, help);
    }

    protected Browser<Act> createDocumentBrowser(Party patient, LayoutContext layout) {
        return BrowserFactory.create(new PatientDocumentQuery(patient), (LayoutContext)layout);
    }

    protected CRUDWindow<Act> createDocumentCRUDWindow(Context context, HelpContext help) {
        return new PatientDocumentCRUDWindow(this.docArchetypes, context, help);
    }

    protected Browser<Act> createChargeBrowser(Party patient, LayoutContext layout) {
        String[] statuses = new String[]{};
        DefaultActQuery query = new DefaultActQuery((Entity)patient, "patient", "participation.patient", CHARGES_SHORT_NAMES, false, statuses);
        query.setDefaultSortConstraint(DEFAULT_SORT);
        query.setMaxResults(10);
        ChargesActTableModel chargeModel = new ChargesActTableModel(query.getShortNames(), layout);
        return new DefaultIMObjectTableBrowser((Query)query, (IMTableModel)chargeModel, layout);
    }

    protected CRUDWindow<Act> createChargesCRUDWindow(Context context, HelpContext help) {
        return new ChargesCRUDWindow(context, help);
    }

    protected CRUDWindow<Act> createPrescriptionCRUDWindow(Context context, HelpContext help) {
        return new PatientPrescriptionCRUDWindow(this.prescriptionArchetypes, context, help.subtopic("prescription"));
    }

    protected CRUDWindow<Act> createEstimateCRUDWindow(Context context, HelpContext help) {
        return new PatientEstimateCRUDWindow(context, help.subtopic("estimate"));
    }

    protected Browser<Act> createCommunicationBrowser(Party patient, Context context, HelpContext help) {
        PatientCommunicationQuery query = new PatientCommunicationQuery(patient);
        return BrowserFactory.create((Query)query, (LayoutContext)new DefaultLayoutContext(context, help));
    }

    protected Browser<Act> createInsuranceBrowser(Party patient, Context context, HelpContext help) {
        InsuranceQuery query = new InsuranceQuery(patient);
        return new InsuranceBrowser(query, (LayoutContext)new DefaultLayoutContext(context, help));
    }

    protected void onBrowserSelected(int selected) {
        super.onBrowserSelected(selected);
        if (selected == this.communicationIndex) {
            this.query(this.communication);
        }
    }

    protected void followHyperlink(IMObject object) {
        if (TypeHelper.isA((IMObject)object, (String)"act.patientClinicalProblem")) {
            this.showProblem((Act)object);
        } else if (TypeHelper.isA((IMObject)object, (String)"act.patientClinicalEvent")) {
            this.showEvent((Act)object);
        }
    }

    private Browser<Act> createPrescriptionBrowser(Party patient, LayoutContext layout) {
        return BrowserFactory.create((Query)new PatientPrescriptionQuery(patient), (LayoutContext)layout);
    }

    private Browser<Act> createEstimateBrowser(Party patient, LayoutContext layout) {
        Party customer = layout.getContext().getCustomer();
        return BrowserFactory.create((Query)new PatientEstimateQuery(customer, patient), (LayoutContext)layout);
    }

    private void showEvent(Act object) {
        this.showHistory();
        this.history.setSelected(object, true);
    }

    private void showProblem(Act object) {
        this.showProblems();
        this.problems.setSelected(object, true);
    }

    static {
        PROBLEM_STATUSES.setDefault((String)null);
    }
}

