/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.List;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class PrescriptionLayoutStrategy
extends AbstractLayoutStrategy {
    private static final ArchetypeNodes EXCLUDE_DISPENSING = new ArchetypeNodes().exclude(new String[]{"dispensing"});

    protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context, int columns) {
        ComponentSet set = this.createComponentSet(object, properties, context);
        String displayName = Messages.get((String)"patient.prescription.dispensed");
        SimpleProperty dispensed = new SimpleProperty("dispensed", (Object)0, Integer.TYPE, displayName);
        dispensed.setReadOnly(true);
        PrescriptionRules rules = (PrescriptionRules)ServiceHelper.getBean(PrescriptionRules.class);
        int value = rules.getDispensed((Act)object);
        dispensed.setValue((Object)value);
        ComponentState state = this.createComponent((Property)dispensed, object, context);
        set.add(state);
        ComponentGrid grid = new ComponentGrid();
        grid.add(set, columns);
        return grid;
    }

    protected ArchetypeNodes getArchetypeNodes(IMObject object, LayoutContext context) {
        IMObjectBean bean = this.getBean(object);
        if (bean.getValues("dispensing").isEmpty()) {
            return EXCLUDE_DISPENSING;
        }
        return super.getArchetypeNodes(object, context);
    }
}

