/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.LayoutData;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.Quantity;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientActEditor;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.mr.DispensingNotes;
import org.openvpms.web.workspace.patient.mr.DoseManager;
import org.openvpms.web.workspace.patient.mr.PrescriptionLayoutStrategy;

public class PatientPrescriptionEditor
extends PatientActEditor {
    private final Quantity quantity;
    private final DispensingNotes dispensingNotes;
    private final DoseManager doseManager;
    private final PracticeRules rules;
    private static final String PATIENT = "patient";
    private static final String PRODUCT = "product";
    private static final String QUANTITY = "quantity";
    private static final String LABEL = "label";
    private static final String DISP_INSTRUCTIONS = "dispInstructions";

    public PatientPrescriptionEditor(Act act, Act parent, LayoutContext context) {
        super(act, parent, context);
        this.quantity = new Quantity(this.getProperty(QUANTITY), (IMObject)act, this.getLayoutContext());
        this.rules = (PracticeRules)ServiceHelper.getBean(PracticeRules.class);
        this.dispensingNotes = new DispensingNotes();
        if (act.isNew()) {
            this.calculateEndTime();
        }
        this.addStartEndTimeListeners();
        this.dispensingNotes.setProduct((Product)this.getParticipant(PRODUCT));
        this.doseManager = new DoseManager((PatientRules)ServiceHelper.getBean(PatientRules.class), (ProductRules)ServiceHelper.getBean(ProductRules.class), (ArchetypeService)ServiceHelper.getArchetypeService());
    }

    public IMObjectEditor newInstance() {
        return new PatientPrescriptionEditor((Act)this.reload((IMObject)this.getObject()), (Act)this.getParent(), this.getLayoutContext());
    }

    public Product getProduct() {
        return (Product)this.getParticipant(PRODUCT);
    }

    public void setProduct(Product product) {
        this.setParticipant(PRODUCT, (Entity)product);
    }

    public BigDecimal getQuantity() {
        return this.getProperty(QUANTITY).getBigDecimal();
    }

    public String getLabel() {
        return this.getProperty(LABEL).getString();
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    protected void onLayoutCompleted() {
        this.monitorParticipation(PATIENT, entity -> this.updateQuantity());
        ProductParticipationEditor productEditor = this.getProductEditor();
        if (productEditor != null) {
            productEditor.setPatient(this.getPatient());
            productEditor.addModifiableListener(modifiable -> this.onProductChanged());
        }
    }

    protected void onEndTimeChanged() {
        Date start = this.getStartTime();
        Date end = this.getEndTime();
        if (start != null && end != null && end.compareTo(start) < 0) {
            this.calculateEndTime();
        }
    }

    private ProductParticipationEditor getProductEditor() {
        return (ProductParticipationEditor)this.getParticipationEditor(PRODUCT, true);
    }

    private void calculateEndTime() {
        Date start = this.getStartTime();
        Party practice = this.getLayoutContext().getContext().getPractice();
        if (start != null && practice != null) {
            this.setEndTime(this.rules.getPrescriptionExpiryDate(start, practice));
        }
    }

    private void onProductChanged() {
        Product product = this.getProduct();
        if (TypeHelper.isA((IMObject)product, (String)"product.medication")) {
            IMObjectBean bean = this.getBean((IMObject)product);
            Property label = this.getProperty(LABEL);
            label.setValue(bean.getValue(DISP_INSTRUCTIONS));
        }
        this.dispensingNotes.setProduct(product);
        this.updateQuantity();
    }

    private void updateQuantity() {
        Party patient = this.getPatient();
        Product product = this.getProduct();
        if (patient != null && product != null) {
            BigDecimal dose = this.doseManager.getDose(product, patient);
            if (!MathRules.isZero((BigDecimal)dose)) {
                this.quantity.setValue(dose, true);
            } else {
                this.quantity.setValue(BigDecimal.ONE, false);
            }
        }
    }

    private class LayoutStrategy
    extends PrescriptionLayoutStrategy {
        private LayoutStrategy() {
        }

        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            this.addComponent(PatientPrescriptionEditor.this.quantity.getState());
            return super.apply(object, properties, parent, context);
        }

        @Override
        protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context, int columns) {
            ComponentGrid grid = super.createGrid(object, properties, context, columns);
            ComponentState usage = PatientPrescriptionEditor.this.dispensingNotes.getComponent(context);
            Column label = ColumnFactory.create((Component[])new Component[]{usage.getLabel()});
            Column text = ColumnFactory.create((Component[])new Component[]{usage.getComponent()});
            text.setLayoutData((LayoutData)ComponentGrid.layout((int)1, (int)(columns * 2 - 1)));
            grid.add(new Component[]{label, text});
            return grid;
        }
    }
}

