/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.doc.DocumentActLayoutStrategy;
import org.openvpms.web.component.im.doc.DocumentEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.PatientHistoryDatingPolicy;

public class PatientDocumentActLayoutStrategy
extends DocumentActLayoutStrategy {
    protected static ArchetypeNodes EDIT_NODES = new ArchetypeNodes(NODES).excludeIfEmpty(new String[]{"invoiceItem"});
    private final boolean locked;
    private final PatientHistoryDatingPolicy policy;

    public PatientDocumentActLayoutStrategy() {
        this(null, null, false);
    }

    public PatientDocumentActLayoutStrategy(DocumentEditor editor, ActRelationshipCollectionEditor versionsEditor, boolean locked) {
        super(editor, versionsEditor);
        this.locked = locked;
        this.policy = (PatientHistoryDatingPolicy)ServiceHelper.getBean(PatientHistoryDatingPolicy.class);
        this.setArchetypeNodes(EDIT_NODES);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property startTime = properties.get("startTime");
        if (context.isEdit() && !startTime.isReadOnly() && !this.policy.canEditStartTime((Act)object)) {
            IMObjectComponentFactory factory = context.getComponentFactory();
            this.addComponent(factory.create(this.createReadOnly(startTime), object));
        }
        return super.apply(object, properties, parent, context);
    }

    protected ComponentState createComponent(Property property, IMObject parent, LayoutContext context) {
        if (context.isEdit() && this.locked && this.makeReadOnly(property)) {
            property = this.createReadOnly(property);
        }
        return super.createComponent(property, parent, context);
    }

    protected boolean makeReadOnly(Property property) {
        return !property.isReadOnly();
    }
}

