/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.Date;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.alert.AbstractAlertActEditor;

public class PatientAlertEditor
extends AbstractAlertActEditor {
    private final ReminderRules rules;
    private boolean markCompleted = true;

    public PatientAlertEditor(Act act, Act parent, LayoutContext context) {
        super(act, (IMObject)parent, context);
        if (act.isNew()) {
            this.initParticipant("patient", (IMObject)context.getContext().getPatient());
        }
        this.addStartEndTimeListeners();
        this.rules = (ReminderRules)ServiceHelper.getBean(ReminderRules.class);
    }

    public void setPatient(Party patient) {
        this.setParticipant("patient", (Entity)patient);
    }

    public Party getPatient() {
        return (Party)this.getParticipant("patient");
    }

    public void setProduct(Product product) {
        this.setParticipant("product", (Entity)product);
    }

    public Product getProduct() {
        return (Product)this.getParticipant("product");
    }

    public void setAlertType(Entity alertType) {
        this.setParticipant("alertType", alertType);
    }

    public Entity getAlertType() {
        return this.getParticipant("alertType");
    }

    public void setMarkMatchingAlertsCompleted(boolean markCompleted) {
        this.markCompleted = markCompleted;
    }

    protected void doSave() {
        boolean isNew = this.getObject().isNew();
        super.doSave();
        if (this.markCompleted && isNew) {
            this.rules.markMatchingAlertsCompleted(this.getObject());
        }
        this.acknowledgeAlert();
    }

    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        Editor alertType = this.getEditor("alertType");
        if (alertType != null) {
            ModifiableListener listener = new ModifiableListener(){

                public void modified(Modifiable modifiable) {
                    PatientAlertEditor.this.onAlertTypeChanged();
                }
            };
            alertType.addModifiableListener(listener);
        }
    }

    private void onAlertTypeChanged() {
        try {
            Entity alertType = this.getAlertType();
            if (alertType != null) {
                IMObjectBean bean = this.getBean((IMObject)alertType);
                String reason = bean.getString("reason");
                this.getProperty("reason").setValue((Object)reason);
                Date startTime = this.getStartTime();
                if (startTime != null) {
                    Date endTime = null;
                    int duration = bean.getInt("duration");
                    String units = bean.getString("durationUnits");
                    if (duration > 0 && units != null) {
                        endTime = DateRules.getDate((Date)startTime, (int)duration, (DateUnits)DateUnits.valueOf((String)units));
                    }
                    this.setEndTime(endTime);
                }
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }
}

