/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class DoseManager {
    private final Map<Reference, Weight> weights = new HashMap<Reference, Weight>();
    private final PatientRules patientRules;
    private final ProductRules productRules;
    private final ArchetypeService service;

    public DoseManager(PatientRules patientRules, ProductRules productRules, ArchetypeService service) {
        this.patientRules = patientRules;
        this.productRules = productRules;
        this.service = service;
    }

    public BigDecimal getDose(Product product, Party patient) {
        Weight weight = this.getWeight(patient);
        return this.productRules.getDose(product, weight, this.getSpecies(patient));
    }

    private Weight getWeight(Party patient) {
        Weight weight = this.weights.get(patient.getObjectReference());
        if (weight == null) {
            weight = this.patientRules.getWeight(patient);
            this.weights.put(patient.getObjectReference(), weight);
        }
        return weight;
    }

    private String getSpecies(Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        return bean.getString("species");
    }
}

