/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientInformationService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.workspace.ActCRUDWindow;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.info.PatientContextHelper;

public class AlertCRUDWindow
extends ActCRUDWindow<Act> {
    public AlertCRUDWindow(Context context, HelpContext help) {
        super(Archetypes.create((String)"act.patientAlert", Act.class), ActActions.edit(), context, help);
    }

    protected void onSaved(Act object, boolean isNew) {
        super.onSaved(object, isNew);
        this.checkAllergyUpdate(object);
    }

    protected void onDeleted(Act object) {
        super.onDeleted((IMObject)object);
        this.checkAllergyUpdate(object);
    }

    private void checkAllergyUpdate(Act object) {
        PatientContext context;
        PatientRules rules;
        if (TypeHelper.isA((IMObject)object, (String)"act.patientAlert") && (rules = (PatientRules)ServiceHelper.getBean(PatientRules.class)).isAllergy(object) && (context = PatientContextHelper.getPatientContext(object, this.getContext())) != null) {
            PatientInformationService service = (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class);
            service.updated(context);
        }
    }
}

