/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.Date;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.act.ActEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;

public abstract class AbstractPatientClinicalActEditor
extends ActEditor {
    private final String completedStatus;

    public AbstractPatientClinicalActEditor(Act act, IMObject parent, String completedStatus, LayoutContext context) {
        super(act, parent, false, context);
        this.completedStatus = completedStatus;
        if (act.isNew()) {
            this.initParticipant("patient", (IMObject)context.getContext().getPatient());
            this.initParticipant("clinician", (IMObject)context.getContext().getClinician());
        }
        this.addStartEndTimeListeners();
        this.getProperty("status").addModifiableListener(modifiable -> this.onStatusChanged());
    }

    public Party getPatient() {
        return (Party)this.getParticipant("patient");
    }

    protected void onStatusChanged() {
        Property status = this.getProperty("status");
        String value = status.getString();
        Date time = this.completedStatus.equals(value) ? new Date() : null;
        this.setEndTime(time, false);
    }
}

