/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.investigation;

import java.util.List;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.component.property.DocumentBackedTextProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;

public class ResultTableModel
extends DescriptorTableModel<Act> {
    private ArchetypeNodes nodes = ArchetypeNodes.nodes((String[])new String[]{"analyteCode", "name", "result", "referenceRange", "status"});
    private boolean showUnits = true;
    private boolean showQualifier = true;
    private boolean showReferenceRange = true;
    private static final String ANALYTE_CODE = "analyteCode";
    private static final String ANALYTE_NAME = "name";
    private static final String RESULT = "result";
    private static final String LONG_RESULT = "longResult";
    private static final String IMAGE = "image";
    private static final String OUT_OF_RANGE = "outOfRange";
    private static final String UNITS = "units";
    private static final String QUALIFIER = "qualifier";
    private static final String REFERENCE_RANGE = "referenceRange";
    private static final String STATUS = "status";

    public ResultTableModel(String[] shortNames, LayoutContext context) {
        super(context);
        this.setTableColumnModel(this.createColumnModel(shortNames, context));
    }

    public void setObjects(List<Act> objects) {
        boolean newShowUnits = false;
        boolean newShowQualifier = false;
        boolean newShowReferenceRange = false;
        for (Act act : objects) {
            IMObjectBean bean = this.getBean((IMObject)act);
            if (!newShowUnits && bean.getString(UNITS) != null) {
                newShowUnits = true;
            }
            if (!newShowQualifier && bean.getString(QUALIFIER) != null) {
                newShowQualifier = true;
            }
            if (!newShowReferenceRange && bean.getString(REFERENCE_RANGE) != null) {
                newShowReferenceRange = true;
            }
            if (!newShowUnits || !newShowQualifier || !newShowReferenceRange) continue;
            break;
        }
        if (newShowUnits != this.showUnits || newShowQualifier != this.showQualifier || newShowReferenceRange != this.showReferenceRange) {
            this.nodes = ArchetypeNodes.nodes((String[])new String[]{ANALYTE_CODE, ANALYTE_NAME, RESULT});
            this.showUnits = newShowUnits;
            this.showQualifier = newShowQualifier;
            this.showReferenceRange = newShowReferenceRange;
            if (this.showUnits) {
                this.nodes.list(new String[]{UNITS});
            }
            if (this.showQualifier) {
                this.nodes.list(new String[]{QUALIFIER});
            }
            if (this.showReferenceRange) {
                this.nodes.list(new String[]{REFERENCE_RANGE});
            }
            this.nodes.list(new String[]{STATUS});
            this.setTableColumnModel(this.createColumnModel(new String[]{"act.patientInvestigationResultItem"}, this.getLayoutContext()));
        }
        super.setObjects(objects);
    }

    protected Object getValue(Act object, DescriptorTableColumn column, int row) {
        boolean outOfRange = this.getBean((IMObject)object).getBoolean(OUT_OF_RANGE);
        Object result = column.getName().equals(RESULT) ? this.getResult(object) : super.getValue((IMObject)object, column, row);
        if (outOfRange && result instanceof Component) {
            Object component = result;
            component.setForeground(Color.RED);
            component.setStyleName("bold");
        }
        return result;
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return this.nodes;
    }

    private Component getResult(Act object) {
        Label result = null;
        DocumentBackedTextProperty property = new DocumentBackedTextProperty((IMObject)object, RESULT, LONG_RESULT);
        String text = StringUtils.abbreviate((String)property.getString(), (int)50);
        Label chart = null;
        IMObjectBean bean = this.getBean((IMObject)object);
        if (bean.getTargetRef(IMAGE) != null) {
            chart = LabelFactory.create(null, (String)"chart");
        }
        if (text != null && chart != null) {
            result = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{LabelFactory.text((String)text), chart});
        } else if (text != null) {
            result = LabelFactory.text((String)text);
        } else if (chart != null) {
            result = chart;
        }
        return result;
    }
}

