/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.policy;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.IMObjectTableModelFactory;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.IMObjectTableCollectionViewer;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.system.ServiceHelper;

public class PolicyLayoutStrategy
extends AbstractLayoutStrategy {
    private static final ArchetypeNodes NODES = new ArchetypeNodes().excludeIfEmpty(new String[]{"claims"});

    public PolicyLayoutStrategy() {
        super(NODES);
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        CollectionProperty claims = (CollectionProperty)properties.get("claims");
        if (!claims.isEmpty()) {
            InsuranceRules rules;
            if (context.isEdit() && !(rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class)).canChangePolicyNumber((Act)object)) {
                Property insurerId = properties.get("insurerId");
                DefaultLayoutContext subContext = new DefaultLayoutContext(context);
                ReadOnlyComponentFactory factory = new ReadOnlyComponentFactory((LayoutContext)subContext, "edit");
                subContext.setComponentFactory((IMObjectComponentFactory)factory);
                this.addComponent(factory.create(insurerId, object));
            }
            ClaimViewer viewer = new ClaimViewer(claims, object, context);
            this.addComponent(new ComponentState(viewer.getComponent(), (Property)viewer.getProperty()));
        }
        return super.apply(object, properties, parent, context);
    }

    private class ClaimViewer
    extends IMObjectTableCollectionViewer {
        public ClaimViewer(CollectionProperty property, IMObject parent, LayoutContext layout) {
            super(property, parent, layout);
        }

        protected List<IMObject> getObjects() {
            List values = this.getProperty().getValues();
            ArrayList<IMObject> objects = new ArrayList<IMObject>();
            for (Object value : values) {
                Relationship relationship = (Relationship)value;
                IMObject claim = IMObjectHelper.getObject((Reference)relationship.getSource());
                if (claim == null) continue;
                objects.add(claim);
            }
            return objects;
        }

        protected void browse(IMObject object) {
        }

        protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
            String[] arcetypes = new String[]{"act.patientInsuranceClaim"};
            return IMObjectTableModelFactory.create((String[])arcetypes, (IMObject)this.getObject(), (LayoutContext)context);
        }
    }
}

