/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.policy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.practice.Location;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.policy.Policy;
import org.openvpms.insurance.service.InsuranceService;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.insurance.service.PolicyValidationStatus;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.policy.PolicyEditor;

public class PolicyEditDialog
extends EditDialog {
    private static final Log log = LogFactory.getLog(PolicyEditDialog.class);
    private static final String CHECK_ID = "button.checkpolicy";

    public PolicyEditDialog(IMObjectEditor editor, Context context) {
        super(editor, EditActions.applyOKCancel().and(new String[]{CHECK_ID}), context);
    }

    public PolicyEditor getEditor() {
        return (PolicyEditor)super.getEditor();
    }

    protected void onButton(String button) {
        if (CHECK_ID.equals(button)) {
            this.onCheck();
        } else {
            super.onButton(button);
        }
    }

    protected void onCheck() {
        if (this.save()) {
            PolicyEditor editor = this.getEditor();
            Act act = editor.getObject();
            InsuranceFactory factory = (InsuranceFactory)ServiceHelper.getBean(InsuranceFactory.class);
            Policy policy = factory.createPolicy(act);
            InsuranceServices services = (InsuranceServices)ServiceHelper.getBean(InsuranceServices.class);
            Party insurer = policy.getInsurer();
            InsuranceService service = services.getService(insurer);
            String title = Messages.get((String)"patient.insurance.policy.check.title");
            if (service != null) {
                try {
                    Context context = this.getContext();
                    Location location = factory.getLocation(context.getLocation());
                    PolicyValidationStatus status = service.validate(policy, location);
                    switch (status.getStatus()) {
                        case VALID: {
                            InformationDialog.show((String)title, (String)Messages.format((String)"patient.insurance.policy.check.valid", (Object[])new Object[0]));
                            break;
                        }
                        case INVALID: {
                            ErrorDialog.show((String)title, (String)Messages.format((String)"patient.insurance.policy.check.invalid", (Object[])new Object[]{status.getMessage()}));
                            break;
                        }
                        case NOT_FOUND: {
                            ErrorDialog.show((String)title, (String)Messages.format((String)"patient.insurance.policy.check.notfound", (Object[])new Object[]{insurer.getName()}));
                            break;
                        }
                        case EXPIRED: {
                            editor.setEndTime(DateRules.getYesterday());
                            ErrorDialog.show((String)title, (String)Messages.format((String)"patient.insurance.policy.check.expired", (Object[])new Object[]{insurer.getName()}));
                            break;
                        }
                        case CHANGE_POLICY_NUMBER: {
                            if (((InsuranceRules)ServiceHelper.getBean(InsuranceRules.class)).canChangePolicyNumber(act)) {
                                editor.setPolicyNumber(status.getPolicyNumber());
                                String message = Messages.format((String)"patient.insurance.policy.check.numberupdated", (Object[])new Object[]{insurer.getName()});
                                InformationDialog.show((String)title, (String)message);
                                break;
                            }
                            String message = Messages.format((String)"patient.insurance.policy.check.cannotupdate", (Object[])new Object[]{insurer.getName(), status.getPolicyNumber()});
                            InformationDialog.show((String)title, (String)message);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported policy status: " + status.getStatus());
                        }
                    }
                }
                catch (Throwable exception) {
                    log.error((Object)"Failed to validate policy", exception);
                    ErrorDialog.show((String)title, (String)Messages.format((String)"patient.insurance.policy.check.error", (Object[])new Object[]{this.getName(service), exception.getMessage()}));
                }
            } else {
                InformationDialog.show((String)title, (String)Messages.format((String)"patient.insurance.policy.check.unsupported", (Object[])new Object[]{insurer.getName()}));
            }
        }
    }

    private String getName(InsuranceService service) {
        try {
            return service.getName();
        }
        catch (Throwable exception) {
            log.error((Object)"Failed to get insurance service name", exception);
            return "unknown";
        }
    }
}

