/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.web.component.bound.BoundTextField;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ArchetypeQueryResultSet;
import org.openvpms.web.component.im.query.DefaultQueryExecutor;
import org.openvpms.web.component.im.query.QueryExecutor;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.popup.DropDown;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimContext;

public class PolicyNumberEditor
extends AbstractPropertyEditor {
    private final ClaimContext claimContext;
    private final LayoutContext layoutContext;
    private final FocusGroup focusGroup;
    private final ModifiableListener listener;
    private final DropDown dropDown;

    public PolicyNumberEditor(Property property, ClaimContext claimContext, LayoutContext layoutContext) {
        super(property);
        this.claimContext = claimContext;
        this.layoutContext = layoutContext;
        this.focusGroup = new FocusGroup(((Object)((Object)this)).getClass().getSimpleName());
        BoundTextField inputField = new BoundTextField(property);
        inputField.setStyleName("Selector");
        this.dropDown = new DropDown();
        this.dropDown.setStyleName("default");
        this.dropDown.setTarget((Component)inputField);
        this.dropDown.setPopUpAlwaysOnTop(true);
        this.dropDown.setFocusOnExpand(true);
        this.listener = modifiable -> this.updatePolicies(true);
        this.focusGroup.add((Component)inputField);
        this.updateText();
        this.updatePolicies(false);
        property.addModifiableListener(this.listener);
    }

    public void refresh() {
        this.updateText();
    }

    public Component getComponent() {
        return this.dropDown;
    }

    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    private boolean setPolicy(Act policy, boolean updateText) {
        Act existingPolicy = this.claimContext.getPolicy();
        Party existingInsurer = this.claimContext.getInsurer();
        this.claimContext.setPolicy(policy);
        if (updateText) {
            this.updateText();
        }
        return !Objects.equals(existingPolicy, this.claimContext.getPolicy()) || !Objects.equals(existingInsurer, this.claimContext.getInsurer());
    }

    private void updateText() {
        Property input = this.getProperty();
        try {
            input.removeModifiableListener(this.listener);
            input.setValue((Object)this.claimContext.getPolicyNumber());
        }
        finally {
            input.addModifiableListener(this.listener);
        }
    }

    private void updatePolicies(boolean showPopup) {
        boolean modified = false;
        PagedIMTable<Act> table = null;
        Act policy = this.claimContext.getPolicy();
        Party insurer = this.claimContext.getInsurer();
        String policyNumber = this.getProperty().getString();
        if (insurer != null) {
            boolean useDefault = showPopup;
            if (policy != null && Objects.equals(policyNumber, this.claimContext.getPolicyNumber())) {
                policyNumber = null;
            } else if (policy != null && policyNumber == null) {
                useDefault = false;
                modified = this.setPolicy(null, false);
            }
            ResultSet<Act> set = this.createResultSet(policyNumber);
            if (set.hasNext()) {
                IPage next = (IPage)set.next();
                List results = next.getResults();
                if (results.size() >= 1) {
                    set.previous();
                    table = this.createTable(set);
                    if (useDefault && (policy == null || results.size() == 1)) {
                        modified = this.setPolicy((Act)results.get(0), true);
                        showPopup = false;
                    }
                }
            } else if (!StringUtils.isEmpty((CharSequence)policyNumber)) {
                modified |= this.claimContext.setPolicyNumber(policyNumber);
                set = this.createResultSet(null);
                if (set.hasNext()) {
                    table = this.createTable(set);
                }
            }
        }
        if (table != null) {
            table.getTable().setSelected((Object)this.claimContext.getPolicy());
            Column newValue = ColumnFactory.create((String)"Inset", (Component[])new Component[]{table.getComponent()});
            this.dropDown.setPopUp((Component)newValue);
            this.dropDown.setFocusComponent(table.getComponent());
        } else {
            Label component = LabelFactory.create((String)"imobject.none");
            Column newValue = ColumnFactory.create((String)"Inset", (Component[])new Component[]{component});
            this.dropDown.setPopUp((Component)newValue);
            this.dropDown.setFocusComponent(null);
        }
        if (showPopup) {
            this.dropDown.setExpanded(true);
        }
        if (modified) {
            this.modified();
        }
    }

    private ResultSet<Act> createResultSet(String policyNumber) {
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"act", (String)"act.patientInsurancePolicy"));
        query.add((IConstraint)Constraints.join((String)"customer").add((IConstraint)Constraints.eq((String)"entity", (Object)this.claimContext.getCustomer())).add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientInsurancePolicy")));
        query.add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.eq((String)"entity", (Object)this.claimContext.getPatient())).add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientInsurancePolicy")));
        if (policyNumber != null) {
            if (!policyNumber.endsWith("*")) {
                policyNumber = policyNumber + "*";
            }
            query.add((IConstraint)Constraints.join((String)"insurerId").add((IConstraint)Constraints.eq((String)"identity", (Object)policyNumber)));
        }
        query.add((IConstraint)Constraints.sort((String)"startTime", (boolean)false));
        query.add((IConstraint)Constraints.sort((String)"id", (boolean)false));
        return new ArchetypeQueryResultSet(query, 5, (QueryExecutor)new DefaultQueryExecutor());
    }

    private PagedIMTable<Act> createTable(ResultSet<Act> set) {
        String[] archetypes = new String[]{"act.patientInsurancePolicy"};
        DefaultDescriptorTableModel model = new DefaultDescriptorTableModel(archetypes, this.layoutContext, new String[]{"insurer", "insurerId", "startTime", "endTime"});
        final PagedIMTable table = new PagedIMTable((IMTableModel)model, set);
        table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                PolicyNumberEditor.this.setPolicy((Act)table.getTable().getSelected(), true);
                PolicyNumberEditor.this.dropDown.setExpanded(false);
            }
        });
        return table;
    }
}

