/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.DelegatingProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.workspace.patient.insurance.claim.AbstractClaimLayoutStrategy;

public class ClaimViewLayoutStrategy
extends AbstractClaimLayoutStrategy {
    private final SimpleProperty insurer = new SimpleProperty("insurer", IMObjectReference.class);
    private final SimpleProperty policyNumber = new SimpleProperty("policyNumber", String.class);
    private static final String GAP_STATUS = "status2";
    private static final String BENEFIT_AMOUNT = "benefitAmount";
    private static final String PAID = "paid";
    private static final String BENEFIT_NOTES = "benefitNotes";

    public ClaimViewLayoutStrategy() {
        super(true);
        this.insurer.setDisplayName(this.getDisplayName("act.patientInsurancePolicy", "insurer"));
        this.insurer.setArchetypeRange(new String[]{"party.supplierInsurer"});
        this.policyNumber.setDisplayName(this.getDisplayName("act.patientInsurancePolicy", "insurerId"));
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        IMObjectBean policy;
        IMObjectBean bean = this.getBean(object);
        if (bean.getBoolean("gapClaim")) {
            ComponentState state;
            this.getArchetypeNodes().simple(new String[]{GAP_STATUS, BENEFIT_AMOUNT, PAID, BENEFIT_NOTES}).hidden(true);
            Property notes = properties.get(BENEFIT_NOTES);
            int lines = StringUtils.countMatches((CharSequence)notes.getString(), (CharSequence)"\n") + 1;
            if (lines > 1) {
                state = this.createComponent(notes, object, context);
                Component component = state.getComponent();
                if (component instanceof TextArea) {
                    TextArea text = (TextArea)component;
                    text.setHeight(new Extent(lines + 1, 64));
                }
            } else {
                DelegatingProperty p = new DelegatingProperty(notes){

                    public int getMaxLength() {
                        return 255;
                    }
                };
                state = this.createComponent((Property)p, object, context);
            }
            this.addComponent(state);
        }
        if ((policy = this.getPolicy(bean)) != null) {
            this.insurer.setValue((Object)policy.getTargetRef("insurer"));
            ActIdentity insurerId = (ActIdentity)policy.getObject("insurerId", ActIdentity.class);
            if (insurerId != null) {
                this.policyNumber.setValue((Object)insurerId.getIdentity());
            }
        }
        return super.apply(object, properties, parent, context);
    }

    @Override
    protected Property getInsurer() {
        return this.insurer;
    }

    @Override
    protected Property getPolicyNumber() {
        return this.policyNumber;
    }

    private IMObjectBean getPolicy(IMObjectBean claim) {
        Act policy = (Act)claim.getTarget("policy", Act.class);
        return policy != null ? this.getBean((IMObject)policy) : null;
    }
}

