/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimSubmitter;

public class ClaimEditDialog
extends EditDialog {
    public static final String SUBMIT_ID = "button.submit";
    private FinancialAct claim;
    private static final Log log = LogFactory.getLog(ClaimEditDialog.class);
    private static final String GENERATE_ID = "button.generateattachments";

    public ClaimEditDialog(ClaimEditor editor, Context context) {
        super((IMObjectEditor)editor, EditActions.applyOKCancel().and(new String[]{GENERATE_ID, SUBMIT_ID}), context);
        this.claim = (FinancialAct)editor.getObject();
    }

    public ClaimEditor getEditor() {
        return (ClaimEditor)super.getEditor();
    }

    public void submit() {
        this.onSubmit();
    }

    public void show() {
        super.show();
        this.getEditor().checkGapClaimAvailability();
    }

    protected void onOK() {
        if (this.getEditor() != null) {
            super.onOK();
        } else {
            this.close("ok");
        }
    }

    protected void onButton(String button) {
        if (GENERATE_ID.equals(button)) {
            this.onGenerate();
        } else if (SUBMIT_ID.equals(button)) {
            this.onSubmit();
        } else {
            super.onButton(button);
        }
    }

    protected void onGenerate() {
        if (this.save()) {
            ClaimEditor editor = this.getEditor();
            editor.generateAttachments(success -> {
                if (success == null || !success.booleanValue()) {
                    editor.showAttachments();
                    editor.checkAttachments();
                }
            });
        }
    }

    protected void onSubmit() {
        Consumer<Throwable> listener = exception -> {
            if (exception != null || !Claim.Status.SUBMITTED.isA(this.claim.getStatus())) {
                this.reloadOnSubmitFailure((Throwable)exception);
            } else {
                this.setAction(SUBMIT_ID);
                this.close();
            }
        };
        if (Claim.Status.PENDING.isA(this.claim.getStatus())) {
            if (this.save()) {
                try {
                    ClaimSubmitter submitter = this.createSubmitter();
                    submitter.submit(this.getEditor(), listener);
                }
                catch (Throwable exception2) {
                    this.reloadOnSubmitFailure(exception2);
                }
            }
        } else if (Claim.Status.POSTED.isA(this.claim.getStatus())) {
            ClaimSubmitter submitter = this.createSubmitter();
            submitter.submit((Act)this.claim, listener);
        } else {
            this.setAction(SUBMIT_ID);
            this.close();
        }
    }

    private ClaimSubmitter createSubmitter() {
        return new ClaimSubmitter((IArchetypeService)ServiceHelper.getArchetypeService(), (InsuranceFactory)ServiceHelper.getBean(InsuranceFactory.class), (InsuranceServices)ServiceHelper.getBean(InsuranceServices.class), this.getContext(), this.getHelpContext());
    }

    private void reloadOnSubmitFailure(Throwable exception) {
        HelpContext help = this.getHelpContext();
        FinancialAct act = (FinancialAct)IMObjectHelper.reload((IMObject)this.claim);
        if (act != null) {
            this.claim = act;
            if (Claim.Status.PENDING.isA(act.getStatus())) {
                ClaimEditor newEditor = new ClaimEditor(act, null, (LayoutContext)new DefaultLayoutContext(true, this.getContext(), help));
                this.setEditor((IMObjectEditor)newEditor);
                if (!newEditor.checkAttachments()) {
                    newEditor.showAttachments();
                }
            } else {
                this.setEditor(null);
                IMObjectViewer viewer = new IMObjectViewer((IMObject)this.claim, (LayoutContext)new DefaultLayoutContext(this.getContext(), help));
                this.setComponent(viewer.getComponent(), viewer.getFocusGroup(), help);
            }
        } else {
            this.setEditor(null);
            this.saveFailed();
        }
        if (exception != null) {
            log.error((Object)"Failed to submit claim", exception);
            String displayName = DescriptorHelper.getDisplayName((IMObject)this.claim, (ArchetypeService)ServiceHelper.getArchetypeService());
            ErrorHelper.show((String)Messages.get((String)"patient.insurance.submit.title"), (String)displayName, (IMObject)this.claim, (Throwable)exception);
        }
    }
}

