/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectTableCollectionEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ChargeBrowser;
import org.openvpms.web.workspace.patient.insurance.claim.Charges;

public class ChargeCollectionEditor
extends IMObjectTableCollectionEditor {
    private final Party customer;
    private final Party patient;
    private final Charges charges;
    private final AttachmentCollectionEditor attachments;

    public ChargeCollectionEditor(CollectionProperty property, Act object, Party customer, Party patient, Charges charges, AttachmentCollectionEditor attachments, LayoutContext context) {
        super((CollectionPropertyEditor)new ChargeRelationshipCollectionPropertyEditor(property, object, charges, (IMObjects)context.getCache()), (IMObject)object, context);
        this.customer = customer;
        this.patient = patient;
        this.charges = charges;
        this.attachments = attachments;
    }

    public List<Act> getActs() {
        return new ArrayList<Act>(this.getCollectionPropertyEditor().getActs().keySet());
    }

    public boolean canClaim(Act item) {
        return this.charges.canClaimItem(item);
    }

    protected void createEditors() {
    }

    protected ChargeRelationshipCollectionPropertyEditor getCollectionPropertyEditor() {
        return (ChargeRelationshipCollectionPropertyEditor)super.getCollectionPropertyEditor();
    }

    protected void onSelected() {
        this.enableNavigation(this.getSelected() != null, true);
    }

    protected IMObjectEditor edit(IMObject object) {
        return null;
    }

    protected IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        throw new IllegalStateException("Charges may not be edited");
    }

    protected IMObjectEditor onAdd() {
        Act act = (Act)this.getObject();
        final ChargeBrowser browser = new ChargeBrowser(this.customer, this.patient, this.charges, act.getActivityStartTime(), act.getActivityEndTime(), this.getContext());
        ChargeBrowserDialog dialog = new ChargeBrowserDialog(browser);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                ChargeCollectionEditor.this.addSelections(browser);
            }
        });
        dialog.show();
        return null;
    }

    protected void addSelections(ChargeBrowser browser) {
        List<FinancialAct> selected = browser.getSelectedItems();
        for (Act act : selected) {
            this.add((IMObject)act);
        }
        this.refresh();
        for (FinancialAct financialAct : browser.getSelectedInvoices()) {
            this.attachments.addInvoice(financialAct);
        }
    }

    private static class ChargeBrowserDialog
    extends PopupDialog {
        public ChargeBrowserDialog(ChargeBrowser browser) {
            super(Messages.format((String)"imobject.select.title", (Object[])new Object[]{DescriptorHelper.getDisplayName((String)"act.customerAccountChargesInvoice", (ArchetypeService)ServiceHelper.getArchetypeService())}), PopupDialog.OK_CANCEL);
            super.setStyleName("BrowserDialog");
            this.setModal(true);
            this.getLayout().add(browser.getComponent());
        }
    }

    private static class ChargeRelationshipCollectionPropertyEditor
    extends ActRelationshipCollectionPropertyEditor {
        private final Charges charges;

        public ChargeRelationshipCollectionPropertyEditor(CollectionProperty property, Act act, Charges charges, IMObjects objects) {
            super(property, act, objects);
            this.charges = charges;
            for (Act object : this.getActs().keySet()) {
                charges.add(object);
            }
        }

        public boolean add(IMObject object) {
            boolean add = super.add(object);
            this.charges.add((Act)object);
            return add;
        }

        public boolean remove(IMObject object) {
            boolean remove = super.remove(object);
            this.charges.remove((Act)object);
            return remove;
        }

        protected void queueRemove(IMObject object, IMObjectEditor editor) {
        }
    }
}

