/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.edit.Deletable;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.MultiSelectBrowser;
import org.openvpms.web.component.im.query.MultiSelectBrowserDialog;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.mail.ActAttachment;
import org.openvpms.web.component.mail.MailAttachment;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimCustomerPatientDocumentBrowser;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

class AttachmentCollectionEditor
extends ActRelationshipCollectionEditor
implements Deletable {
    private final IArchetypeRuleService service = ServiceHelper.getArchetypeService();

    public AttachmentCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
        super(property, act, context);
        this.setExcludeDefaultValueObject(false);
        this.getCollectionPropertyEditor().setRemoveHandler(new CollectionPropertyEditor.RemoveHandler(){

            public void remove(IMObject object) {
                AttachmentCollectionEditor.this.remove((DocumentAct)object);
            }

            public void remove(IMObjectEditor editor) {
                this.remove(editor.getObject());
            }
        });
    }

    public DocumentAct addDocument(DocumentAct document) {
        DocumentAct attachment = this.getAttachment((Act)document);
        if (attachment == null) {
            attachment = this.createDocument(document);
            this.add((IMObject)attachment);
            this.refresh();
        }
        return attachment;
    }

    public DocumentAct addInvoice(FinancialAct invoice) {
        DocumentAct attachment = this.getAttachment((Act)invoice);
        if (attachment == null) {
            attachment = this.createInvoice(invoice);
            this.add((IMObject)attachment);
            this.refresh();
        }
        return attachment;
    }

    public DocumentAct getHistory() {
        DocumentAct result = null;
        for (Act attachment : this.getCurrentActs()) {
            if (!this.isHistory(attachment)) continue;
            result = (DocumentAct)attachment;
            break;
        }
        return result;
    }

    public DocumentAct createHistory() {
        DocumentAct act = (DocumentAct)IMObjectCreator.create((String)"act.patientInsuranceClaimAttachment");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("name", (Object)"Patient History");
        bean.setValue("type", (Object)"act.patientClinicalEvent");
        return act;
    }

    public void deleteGeneratedDocuments() {
        List acts = this.getCurrentActs();
        boolean needsRefresh = false;
        if (!acts.isEmpty()) {
            PlatformTransactionManager transactionManager = (PlatformTransactionManager)ServiceHelper.getBean(PlatformTransactionManager.class);
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            TransactionTemplate template = new TransactionTemplate(transactionManager);
            for (Act act : acts) {
                Boolean removed;
                IMObjectBean bean = this.getBean((IMObject)act);
                if (!this.isGenerated(bean) || (removed = (Boolean)template.execute(transactionStatus -> {
                    Reference document = bean.getReference("document");
                    if (document != null) {
                        bean.setValue("document", null);
                        bean.save();
                        service.remove(document);
                        return true;
                    }
                    return false;
                })) == null || !removed.booleanValue()) continue;
                needsRefresh = true;
                this.refresh((DocumentAct)act);
            }
            if (needsRefresh) {
                this.refresh();
            }
        }
    }

    public void refresh(DocumentAct document) {
        IMObjectEditor editor = this.getEditor((IMObject)document);
        if (editor instanceof AttachmentEditor) {
            ((AttachmentEditor)editor).refresh();
        }
    }

    public void delete() {
        IMObjectBean bean = this.getBean(this.getObject());
        ArrayList<Object> toSave = new ArrayList<Object>();
        for (Act act : this.getCurrentActs()) {
            bean.removeTargets("attachments", (IMObject)act, "claim");
            toSave.add(act);
        }
        if (!toSave.isEmpty()) {
            toSave.add(this.getObject());
            this.service.save(toSave);
            for (Act act : this.getCurrentActs()) {
                this.remove((DocumentAct)act);
            }
        }
    }

    protected IMObjectEditor onAdd() {
        LayoutContext layout = this.getContext();
        Context context = layout.getContext();
        Party customer = context.getCustomer();
        Party patient = context.getPatient();
        ClaimCustomerPatientDocumentBrowser browser = new ClaimCustomerPatientDocumentBrowser(customer, patient, false, null, null, layout);
        String title = Messages.get((String)"patient.insurance.attach.title");
        MultiSelectBrowserDialog dialog = new MultiSelectBrowserDialog(title, (MultiSelectBrowser)browser, layout.getHelpContext());
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener((MultiSelectBrowser)browser){
            final /* synthetic */ MultiSelectBrowser val$browser;
            {
                this.val$browser = multiSelectBrowser;
            }

            public void onOK() {
                for (MailAttachment attachment : this.val$browser.getSelections()) {
                    ActAttachment act;
                    if (!(attachment instanceof ActAttachment) || !((act = (ActAttachment)attachment).getContent() instanceof DocumentAct)) continue;
                    AttachmentCollectionEditor.this.addDocument((DocumentAct)act.getContent());
                }
            }
        });
        dialog.show();
        return null;
    }

    private void remove(DocumentAct object) {
        Reference reference = object.getDocument();
        if (!object.isNew()) {
            this.service.remove((IMObject)object);
        }
        if (reference != null && !reference.isNew()) {
            this.service.remove(reference);
        }
    }

    private DocumentAct getAttachment(Act act) {
        DocumentAct result = null;
        Reference reference = act.getObjectReference();
        for (Act attachment : this.getCurrentActs()) {
            IMObjectBean bean = this.getBean((IMObject)attachment);
            if (!Objects.equals(reference, bean.getTargetRef("original"))) continue;
            result = (DocumentAct)attachment;
            break;
        }
        return result;
    }

    private boolean isGenerated(IMObjectBean bean) {
        String type = bean.getString("type");
        return type != null && (type.equals("act.patientClinicalEvent") || type.equals("act.customerAccountChargesInvoice") || type.equals("act.patientDocumentForm") || type.equals("act.customerDocumentForm"));
    }

    private DocumentAct createDocument(DocumentAct original) {
        IMObjectBean bean = this.create((Act)original, original.getName());
        bean.setValue("fileName", (Object)original.getFileName());
        bean.setValue("mimeType", (Object)original.getMimeType());
        return (DocumentAct)bean.getObject();
    }

    private DocumentAct createInvoice(FinancialAct original) {
        IMObjectBean bean = this.create((Act)original, original.getName() + " " + original.getId());
        return (DocumentAct)bean.getObject();
    }

    private IMObjectBean create(Act original, String name) {
        Act act = (Act)IMObjectCreator.create((String)"act.patientInsuranceClaimAttachment");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("startTime", (Object)original.getActivityStartTime());
        bean.setValue("name", (Object)name);
        bean.setValue("type", (Object)original.getArchetype());
        ActRelationship relationship = (ActRelationship)bean.addTarget("original", (IMObject)original);
        original.addActRelationship(relationship);
        return bean;
    }

    private boolean isHistory(Act attachment) {
        return "act.patientClinicalEvent".equals(this.getBean((IMObject)attachment).getString("type"));
    }
}

