/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance;

import java.util.Objects;
import java.util.function.Consumer;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ActCRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindowListener;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.OptionDialog;
import org.openvpms.web.echo.dialog.OptionDialogBuilder;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.InsuranceActions;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimEditDialog;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimSubmitter;

public class InsuranceCRUDWindow
extends ActCRUDWindow<Act> {
    private final boolean noCreate;
    private final InsuranceRules rules;
    private static final String NEW_ID = "button.newpolicy";
    private static final String CLAIM_ID = "button.claim";
    private static final String SUBMIT_ID = "button.submit";
    private static final String PAY_ID = "button.payclaim";
    private static final String CANCEL_CLAIM_ID = "button.cancelclaim";
    private static final String SETTLE_CLAIM_ID = "button.settleclaim";
    private static final String DECLINE_CLAIM_ID = "button.declineclaim";

    public InsuranceCRUDWindow(Context context, HelpContext help) {
        this(false, context, help);
    }

    protected InsuranceCRUDWindow(boolean noCreate, Context context, HelpContext help) {
        super(Archetypes.create((String)"act.patientInsurancePolicy", Act.class), (ActActions)InsuranceActions.INSTANCE, context, help);
        this.noCreate = noCreate;
        this.rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
    }

    protected void layoutButtons(ButtonSet buttons) {
        if (!this.noCreate) {
            buttons.add(this.createNewButton());
        }
        buttons.add(this.createEditButton());
        buttons.add(this.createDeleteButton());
        if (!this.noCreate) {
            buttons.add(CLAIM_ID, this.action(this::claim, false, "patient.insurance.claim.title"));
        }
        buttons.add(SUBMIT_ID, this.action("act.patientInsuranceClaim", this::submit, "patient.insurance.submit.title"));
        buttons.add(PAY_ID, this.action("act.patientInsuranceClaim", this::payClaim, "patient.insurance.pay.title"));
        buttons.add(CANCEL_CLAIM_ID, this.action("act.patientInsuranceClaim", this::cancelClaim, "patient.insurance.cancel.title"));
        buttons.add(SETTLE_CLAIM_ID, this.action("act.patientInsuranceClaim", this::settleClaim, "patient.insurance.settle.title"));
        buttons.add(DECLINE_CLAIM_ID, this.action("act.patientInsuranceClaim", this::declineClaim, "patient.insurance.decline.title"));
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
    }

    protected Button createNewButton() {
        return ButtonFactory.create((String)NEW_ID, () -> ((InsuranceCRUDWindow)this).create());
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        Act object = (Act)this.getObject();
        buttons.setEnabled(SUBMIT_ID, enable && this.getActions().canSubmit(object));
        buttons.setEnabled(PAY_ID, enable && this.getActions().canPayClaim(object));
        buttons.setEnabled(CANCEL_CLAIM_ID, enable && this.getActions().canCancelClaim(object));
        buttons.setEnabled(SETTLE_CLAIM_ID, enable && this.getActions().canSettleClaim(object));
        buttons.setEnabled(DECLINE_CLAIM_ID, enable && this.getActions().canDeclineClaim(object));
        this.enablePrintPreview(buttons, enable && object.isA("act.patientInsuranceClaim"));
    }

    protected InsuranceActions getActions() {
        return (InsuranceActions)super.getActions();
    }

    protected void print(Act object) {
        if (object.isA("act.patientInsuranceClaim")) {
            ClaimSubmitter submitter = this.createSubmitter(this.getHelpContext());
            submitter.print(object, this.createRefreshAction(object, "printdialog.title"));
        } else {
            super.print(object);
        }
    }

    protected void mail(Act object) {
        if (object.isA("act.patientInsuranceClaim")) {
            ClaimSubmitter submitter = this.createSubmitter(this.getHelpContext());
            submitter.mail(object);
        } else {
            super.mail(object);
        }
    }

    protected void claim(Act act) {
        Party currentOwner = this.getContext().getCustomer();
        Act policy = this.getPolicy(act);
        if (policy != null) {
            IMObjectBean bean = this.getBean((IMObject)policy);
            Party customer = (Party)bean.getTarget("customer", Party.class);
            Party patient = (Party)bean.getTarget("patient", Party.class);
            if (customer != null && patient != null) {
                Party currentPatient = this.getContext().getPatient();
                if (!Objects.equals(currentOwner, customer)) {
                    ((ErrorDialogBuilder)ErrorDialog.newDialog().messageKey("patient.insurance.customermismatch", new Object[]{customer.getName()})).show();
                } else if (!Objects.equals(currentPatient, patient)) {
                    ((ErrorDialogBuilder)ErrorDialog.newDialog().messageKey("patient.insurance.patientmismatch", new Object[]{patient.getName()})).show();
                } else {
                    this.checkPolicyLatestThenCreateClaim(policy, customer, patient);
                }
            }
        } else if (currentOwner == null) {
            ((ErrorDialogBuilder)ErrorDialog.newDialog().messageKey("patient.insurance.claim.noowner", new Object[0])).show();
        } else {
            Act claim = (Act)this.getService().create("act.patientInsuranceClaim", Act.class);
            this.edit((IMObject)claim, null);
        }
    }

    protected void submit(final Act object) {
        if (Claim.Status.PENDING.isA(object.getStatus())) {
            HelpContext edit = this.createEditTopic((IMObject)object);
            LayoutContext context = this.createLayoutContext(edit);
            ClaimEditDialog dialog = (ClaimEditDialog)this.edit(this.createEditor((IMObject)object, context));
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    InsuranceCRUDWindow.this.onRefresh(object);
                }
            });
            dialog.show();
            dialog.submit();
        } else if (Claim.Status.POSTED.isA(object.getStatus())) {
            ClaimSubmitter submitter = this.createSubmitter(this.getHelpContext());
            submitter.submit(object, this.createRefreshAction(object, "patient.insurance.submit.title"));
        }
    }

    protected void payClaim(Act object) {
        if (this.getActions().canPayClaim(object)) {
            ClaimSubmitter submitter = this.createSubmitter(this.getHelpContext());
            submitter.pay(object, this.createRefreshAction(object, "patient.insurance.pay.title"));
        } else {
            this.onRefresh(object);
        }
    }

    protected void cancelClaim(Act object) {
        if (this.getActions().canCancelClaim(object)) {
            ClaimSubmitter submitter = this.createSubmitter(this.getHelpContext().subtopic("cancel"));
            submitter.cancel(object, this.createRefreshAction(object, "patient.insurance.cancel.title"));
        }
    }

    protected void settleClaim(Act object) {
        if (this.getActions().canSettleClaim(object)) {
            ClaimSubmitter submitter = this.createSubmitter(this.getHelpContext().subtopic("settle"));
            submitter.settle(object, this.createRefreshAction(object, "patient.insurance.settle.title"));
        }
    }

    protected void declineClaim(Act object) {
        if (this.getActions().canDeclineClaim(object)) {
            ClaimSubmitter submitter = this.createSubmitter(this.getHelpContext().subtopic("decline"));
            submitter.decline(object, this.createRefreshAction(object, "patient.insurance.decline.title"));
        }
    }

    protected void onRefresh(Act object) {
        Act refreshed = (Act)IMObjectHelper.reload((IMObject)object);
        this.setObject(refreshed);
        CRUDWindowListener listener = this.getListener();
        if (listener != null) {
            listener.refresh((IMObject)object);
        }
    }

    private ClaimSubmitter createSubmitter(HelpContext help) {
        return new ClaimSubmitter((IArchetypeService)ServiceHelper.getArchetypeService(), (InsuranceFactory)ServiceHelper.getBean(InsuranceFactory.class), (InsuranceServices)ServiceHelper.getBean(InsuranceServices.class), this.getContext(), help);
    }

    private Consumer<Throwable> createRefreshAction(Act object, String title) {
        return throwable -> {
            if (throwable != null) {
                ErrorHelper.show((String)Messages.get((String)title), (String)this.getDisplayName((IMObject)object), (IMObject)object, (Throwable)throwable);
            }
            this.onRefresh(object);
        };
    }

    private Act getPolicy(Act act) {
        Act policy = null;
        if (act != null) {
            if (act.isA("act.patientInsurancePolicy")) {
                policy = act;
            } else if (act.isA("act.patientInsuranceClaim")) {
                policy = (Act)this.getBean((IMObject)act).getTarget("policy", Act.class);
            }
        }
        return policy;
    }

    private void checkPolicyLatestThenCreateClaim(Act policy, Party customer, Party patient) {
        Act latest = this.rules.getCurrentPolicy(customer, patient);
        if (latest != null && !latest.equals(policy)) {
            String latestOption = this.getPolicyDetails(latest, "patient.insurance.claim.oldpolicy.latest");
            String currentOption = this.getPolicyDetails(policy, "patient.insurance.claim.oldpolicy.current");
            ((OptionDialogBuilder)((OptionDialogBuilder)((OptionDialogBuilder)OptionDialog.newDialog().titleKey("editor.new.title", new Object[]{this.getDisplayName("act.patientInsuranceClaim")})).messageKey("patient.insurance.claim.oldpolicy.message", new Object[0])).addOption(latestOption, () -> this.checkOutstandingClaimsThenCreateClaim(latest)).addOption(currentOption, () -> this.checkOutstandingClaimsThenCreateClaim(policy)).closeOnSelection().cancel()).show();
        } else if (this.rules.isExpired(policy)) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("patient.insurance.policy.expired.title", new Object[0])).messageKey("patient.insurance.policy.expired.message", new Object[0])).yesNo()).yes(() -> this.checkOutstandingClaimsThenCreateClaim(policy))).show();
        } else {
            this.checkOutstandingClaimsThenCreateClaim(policy);
        }
    }

    private void checkOutstandingClaimsThenCreateClaim(Act policy) {
        if (!this.getActions().hasExistingClaims(policy)) {
            this.createAndEditClaimForPolicy(policy);
        } else {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("editor.new.title", new Object[]{this.getDisplayName("act.patientInsuranceClaim")})).messageKey("patient.insurance.claim.existing.message", new Object[0])).yesNo()).yes(() -> this.createAndEditClaimForPolicy(policy))).show();
        }
    }

    private String getPolicyDetails(Act policy, String key) {
        String result;
        Party insurer = this.rules.getInsurer(policy);
        String policyNumber = this.rules.getPolicyNumber(policy);
        String string = result = insurer != null ? insurer.getName() : "<unknown>";
        if (policyNumber != null) {
            result = result + " - " + policyNumber;
        }
        if (this.rules.isExpired(policy)) {
            result = result + " - " + Messages.get((String)"patient.insurance.expired");
        }
        return Messages.format((String)key, (Object[])new Object[]{result});
    }

    private void createAndEditClaimForPolicy(Act policy) {
        FinancialAct claim = this.rules.createClaim(policy);
        this.edit((IMObject)claim, null);
    }
}

