/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.info;

import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.patient.PatientQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.workflow.SelectIMObjectTask;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.merge.MergeWorkflow;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

class PatientMergeWorkflow
extends MergeWorkflow<Party> {
    private final Party customer;

    public PatientMergeWorkflow(Party patient, Party customer, HelpContext help) {
        super(patient, help);
        this.customer = customer;
        this.init();
    }

    @Override
    protected TaskContext createContext(HelpContext help) {
        TaskContext context = super.createContext(help);
        context.setCustomer(this.customer);
        return context;
    }

    @Override
    protected SelectIMObjectTask<Party> createSelectTask(Context context) {
        Party patient = (Party)this.getObject();
        String[] shortNames = new String[]{patient.getArchetype()};
        PatientQuery query = new PatientQuery(shortNames, context);
        query.setShowAllPatients(true);
        query.setConstraints((IConstraint)Constraints.not((IConstraint)new ObjectRefConstraint("patient", patient.getObjectReference())));
        return new SelectIMObjectTask((Query)query, this.getHelpContext().topic("patient"));
    }

    @Override
    protected String getConfirmationMessage() {
        Party patientTo = (Party)this.getObject();
        Party patientFrom = this.getContext().getPatient();
        return Messages.format((String)"workflow.merge.message", (Object[])new Object[]{patientTo.getName(), patientTo.getId(), patientFrom.getName(), patientFrom.getId()});
    }

    @Override
    protected Task createMergeTask() {
        return new SynchronousTask(){

            public void execute(TaskContext context) {
                Party from = context.getPatient();
                PatientMergeWorkflow.this.merge(from);
            }
        };
    }

    private void merge(final Party from) {
        TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
        template.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
                rules.mergePatients(from, (Party)PatientMergeWorkflow.this.getObject());
                return true;
            }
        });
    }
}

