/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.info;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.system.ServiceHelper;

public class PatientContextHelper {
    public static PatientContext getAppointmentContext(Act appointment, Context context) {
        PatientContext result = null;
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)appointment);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        Party location = context.getLocation();
        if (patient != null && location != null) {
            Party customer = (Party)bean.getTarget("customer", Party.class);
            PatientContextFactory factory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
            result = factory.createContext(patient, customer, context.getLocation());
        }
        return result;
    }

    public static PatientContext getPatientContext(Act act, Context context) {
        PatientContext result = null;
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)act);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        Party location = context.getLocation();
        if (patient != null && location != null) {
            PatientContextFactory factory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
            result = factory.createContext(patient, location);
        }
        return result;
    }

    public static PatientContext getPatientContext(Party patient, Context context) {
        PatientContext result = null;
        Party location = context.getLocation();
        if (patient != null && location != null) {
            PatientContextFactory factory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
            result = factory.createContext(patient, location);
        }
        return result;
    }
}

