/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.list.ShortNameListModel;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.PageLocator;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.RelationshipHelper;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryQuery;
import org.openvpms.web.workspace.patient.history.ProductTypeSelector;

public class PatientHistoryQuery
extends AbstractPatientHistoryQuery {
    private final boolean sortHistoryAscending;
    private final boolean includeCommunications;
    private CheckBox includeCharges;
    private ProductTypeSelector productType;
    private static final String[] ARCHETYPES = new String[]{"act.patientClinicalEvent", "act.customerCommunication*", "act.smsMessage", "act.smsReply"};
    private static final String[] DOC_VERSION_ARCHETYPES = new String[]{"act.patientInvestigationVersion", "act.patientDocumentAttachmentVersion", "act.patientDocumentImageVersion", "act.patientDocumentLetterVersion"};

    public PatientHistoryQuery(Party patient, Preferences preferences) {
        this(patient, preferences.getBoolean("entity.preferenceGroupHistory", "showCharges", true), preferences.getBoolean("entity.preferenceGroupHistory", "showCommunications", true), PatientHistoryQuery.getSortHistoryAscending(preferences));
        this.setSortAscending(this.getSortAscending(preferences));
    }

    public PatientHistoryQuery(Party patient, boolean charges) {
        this(patient, charges, false);
    }

    public PatientHistoryQuery(Party patient, boolean charges, boolean communications) {
        this(patient, charges, communications, false);
    }

    public PatientHistoryQuery(Party patient, boolean charges, boolean communications, boolean sortHistoryAscending) {
        String[] stringArray;
        if (communications) {
            stringArray = ARCHETYPES;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "act.patientClinicalEvent";
        }
        super(patient, stringArray, null);
        this.sortHistoryAscending = sortHistoryAscending;
        this.includeCommunications = communications;
        this.init(charges);
    }

    public void setIncludeCharges(boolean include) {
        this.includeCharges.setSelected(include);
        this.onIncludeChargesChanged();
    }

    public boolean getIncludeCharges() {
        return this.includeCharges.isSelected();
    }

    public boolean getSortHistoryAscending() {
        return this.sortHistoryAscending;
    }

    public int getPage(Act object) {
        int page = 0;
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)object);
        Reference patient = bean.getTargetRef("patient");
        if (patient != null && Objects.equals(patient, this.getEntityId())) {
            ArchetypeQuery query = new ArchetypeQuery(this.getShortNames(), false, false);
            query.add((IConstraint)new ParticipantConstraint("patient", "participation.patient", patient));
            page = QueryHelper.getPage((IMObject)object, (ArchetypeQuery)query, (int)this.getMaxResults(), (String)"startTime", (boolean)this.sortHistoryAscending, (Comparator)PageLocator.DATE_COMPARATOR);
        }
        return page;
    }

    public Set<Reference> getProductTypes() {
        Set<Reference> result;
        ProductTypeSelector selector = this.getProductTypeSelector();
        if (selector.isAll()) {
            result = Collections.emptySet();
        } else {
            result = new HashSet();
            for (Entity entity : selector.getSelected()) {
                result.add(entity.getObjectReference());
            }
        }
        return result;
    }

    public void setProductTypes(Set<Reference> productTypes) {
        ProductTypeSelector selector = this.getProductTypeSelector();
        selector.setSelected(productTypes);
    }

    public Extent getHeight() {
        return super.getHeight(2);
    }

    public String[] getShortNames() {
        if (this.excludeCommunications()) {
            return new String[]{"act.patientClinicalEvent"};
        }
        return super.getShortNames();
    }

    protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
        ResultSet result;
        if (this.excludeCommunications()) {
            ShortNameConstraint archetypes = new ShortNameConstraint("act.patientClinicalEvent", true, true);
            result = new ActResultSet(archetypes, this.getParticipantConstraint(), this.getFrom(), this.getTo(), this.getStatuses(), this.excludeStatuses(), this.getConstraints(), this.getMaxResults(), sort);
        } else {
            result = super.createResultSet(sort);
        }
        return result;
    }

    protected void init(boolean charges) {
        Object[] itemArchetypes = RelationshipHelper.getTargetShortNames((ArchetypeService)ServiceHelper.getArchetypeService(), (String[])new String[]{"actRelationship.patientClinicalEventItem"});
        this.setAvailableArchetypes((String[])itemArchetypes);
        Object[] archetypes = (String[])ArrayUtils.addAll((Object[])itemArchetypes, (Object[])DOC_VERSION_ARCHETYPES);
        if (this.includeCommunications) {
            ShortNameListModel model = this.getAvailableArchetypesModel();
            model.add("act.customerCommunication*", Messages.get((String)"patient.record.query.communications"), false);
            archetypes = (String[])ArrayUtils.add((Object[])archetypes, (Object)"act.customerCommunication*");
        }
        if (charges) {
            this.setSelectedArchetypes((String[])ArrayUtils.add((Object[])archetypes, (Object)"act.customerAccountInvoiceItem"));
        } else {
            this.setSelectedArchetypes((String[])archetypes);
        }
        this.includeCharges = CheckBoxFactory.create((boolean)charges);
        this.includeCharges.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                PatientHistoryQuery.this.onIncludeChargesChanged();
                PatientHistoryQuery.this.onQuery();
            }
        });
        if (this.sortHistoryAscending) {
            this.setDefaultSortConstraint(ASCENDING_START_TIME);
        } else {
            this.setDefaultSortConstraint(DESCENDING_START_TIME);
        }
    }

    protected void doLayout(Component container) {
        FocusGroup focusGroup = this.getFocusGroup();
        SelectField shortNameSelector = this.getArchetypeSelector();
        Button sort = this.getSort();
        ProductTypeSelector selector = this.getProductTypeSelector();
        container.add((Component)LabelFactory.create((String)"query.type"));
        container.add((Component)shortNameSelector);
        focusGroup.add((Component)shortNameSelector);
        Row subrow = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"patient.record.query.includeCharges"), this.includeCharges, sort});
        container.add((Component)subrow);
        focusGroup.add((Component)this.includeCharges);
        focusGroup.add((Component)sort);
        this.addSearchField((Component)subrow);
        container.add((Component)LabelFactory.create((String)"patient.record.query.productType"));
        container.add((Component)selector);
        focusGroup.add(selector.getTarget());
        this.addDateRange(container);
    }

    protected Component createContainer() {
        return GridFactory.create((int)3);
    }

    @Override
    protected void updateSelectedArchetypes(ShortNameListModel model, int selected) {
        Object[] archetypes;
        if (model.isAll(selected)) {
            archetypes = model.getShortNames();
            archetypes = (String[])ArrayUtils.addAll((Object[])archetypes, (Object[])DOC_VERSION_ARCHETYPES);
        } else {
            String archetype = model.getShortName(selected);
            archetypes = this.getSelectedArchetypes(archetype);
        }
        if (this.includeCharges.isSelected()) {
            archetypes = (String[])ArrayUtils.add((Object[])archetypes, (Object)"act.customerAccountInvoiceItem");
        }
        this.setSelectedArchetypes((String[])archetypes);
    }

    protected static boolean getSortHistoryAscending(Preferences preferences) {
        String sort = preferences.getString("entity.preferenceGroupHistory", "historySort", "DESC");
        return "ASC".equals(sort);
    }

    private boolean excludeCommunications() {
        return this.includeCommunications && !ArrayUtils.contains((Object[])this.getSelectedArchetypes(), (Object)"act.customerCommunication*");
    }

    private String[] getSelectedArchetypes(String archetype) {
        if ("act.patientInvestigation".equals(archetype)) {
            return new String[]{archetype, "act.patientInvestigationVersion"};
        }
        if ("act.patientDocumentAttachment".equals(archetype)) {
            return new String[]{archetype, "act.patientDocumentAttachmentVersion"};
        }
        if ("act.patientDocumentImage".equals(archetype)) {
            return new String[]{archetype, "act.patientDocumentImageVersion"};
        }
        if ("act.patientDocumentLetter".equals(archetype)) {
            return new String[]{archetype, "act.patientDocumentLetterVersion"};
        }
        return new String[]{archetype};
    }

    private void onIncludeChargesChanged() {
        this.updateSelectedArchetypes();
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            preferences.setPreference("entity.preferenceGroupHistory", "showCharges", (Object)this.includeCharges.isSelected());
        }
    }

    private ProductTypeSelector getProductTypeSelector() {
        if (this.productType == null) {
            this.productType = new ProductTypeSelector();
            this.productType.setListener(() -> ((PatientHistoryQuery)this).onQuery());
        }
        return this.productType;
    }
}

