/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.workspace.patient.history.PatientHistoryDatingPolicy;

public class DefaultPatientHistoryDatingPolicy
implements PatientHistoryDatingPolicy {
    private final boolean editFormsAndLetters;
    private final IArchetypeService service;
    private final PracticeService practiceService;

    public DefaultPatientHistoryDatingPolicy(IArchetypeService service, PracticeService practiceService) {
        this(false, service, practiceService);
    }

    public DefaultPatientHistoryDatingPolicy(boolean editFormsAndLetters, IArchetypeService service, PracticeService practiceService) {
        this.editFormsAndLetters = editFormsAndLetters;
        this.service = service;
        this.practiceService = practiceService;
    }

    @Override
    public boolean canEditStartTime(Act act) {
        String status = act.getStatus();
        return !"POSTED".equals(status) && !"CANCELLED".equals(status) && !this.isReadOnly(act) && (this.practiceService.getRecordLockPeriod() == null || TypeHelper.isA((IMObject)act, (String[])new String[]{"act.patientClinicalEvent", "act.patientClinicalProblem"}) || this.editFormsAndLetters && TypeHelper.isA((IMObject)act, (String[])new String[]{"act.patientDocumentForm", "act.patientDocumentLetter"}));
    }

    private boolean isReadOnly(Act act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        NodeDescriptor startTime = bean.getNode("startTime");
        return startTime != null && startTime.isReadOnly();
    }
}

