/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.charge;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.finance.invoice.ChargeItemEventLinker;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.ChargeArchetypeNodesFactory;
import org.openvpms.web.workspace.customer.charge.ChargeLayoutStrategy;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.patient.charge.VisitActRelationshipCollectionEditor;
import org.openvpms.web.workspace.patient.charge.VisitChargeItemRelationshipCollectionEditor;

public class VisitChargeEditor
extends CustomerChargeActEditor {
    private final SimpleProperty visitTotal;
    private final SimpleProperty visitTax;
    private Act event;

    public VisitChargeEditor(FinancialAct act, Act event, LayoutContext context) {
        this(act, event, context, true);
    }

    public VisitChargeEditor(FinancialAct act, Act event, LayoutContext context, boolean addDefaultItem) {
        super(act, null, context, addDefaultItem);
        this.event = event;
        this.visitTotal = new SimpleProperty("visitTotal", (Object)BigDecimal.ZERO, Money.class);
        this.visitTotal.setReadOnly(true);
        this.visitTax = new SimpleProperty("visitTax", (Object)BigDecimal.ZERO, Money.class);
        this.visitTax.setReadOnly(true);
        this.calculateVisitTotals();
    }

    public Act getEvent() {
        return this.event;
    }

    public IMObjectEditor newInstance() {
        return new VisitChargeEditor((FinancialAct)this.reload((IMObject)this.getObject()), (Act)this.reload((IMObject)this.event), this.getLayoutContext(), this.getAddDefaultIem());
    }

    @Override
    public VisitChargeItemRelationshipCollectionEditor getItems() {
        return (VisitChargeItemRelationshipCollectionEditor)super.getItems();
    }

    @Override
    protected void onItemsChanged() {
        super.onItemsChanged();
        this.calculateVisitTotals();
    }

    protected ActRelationshipCollectionEditor createItemsEditor(Act act, CollectionProperty items) {
        return new VisitChargeItemRelationshipCollectionEditor(items, act, this.getLayoutContext());
    }

    @Override
    protected ActRelationshipCollectionEditor createCustomerNotesEditor(Act act, CollectionProperty notes) {
        return new VisitActRelationshipCollectionEditor(notes, act, this.getLayoutContext());
    }

    @Override
    protected ActRelationshipCollectionEditor createDocumentsEditor(Act act, CollectionProperty documents) {
        return new VisitActRelationshipCollectionEditor(documents, act, this.getLayoutContext());
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        VisitChargeLayoutStrategy strategy = new VisitChargeLayoutStrategy();
        this.initLayoutStrategy((IMObjectLayoutStrategy)strategy);
        return strategy;
    }

    @Override
    protected void linkToEvents(PatientHistoryChanges changes) {
        List<Act> chargeItems = this.getItems().getPatientActs();
        if (!chargeItems.isEmpty()) {
            this.event = (Act)this.reload((IMObject)this.event);
            Map<FinancialAct, List<Act>> items = this.getItemsToLinkToEvents(chargeItems);
            changes.addEvent(this.event);
            ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)ServiceHelper.getArchetypeService());
            linker.prepare(this.event, items, changes);
            this.addTemplateNotes(linker, changes);
        }
    }

    private void calculateVisitTotals() {
        VisitChargeItemRelationshipCollectionEditor items = this.getItems();
        List<Act> acts = items.getCurrentPatientActs();
        BigDecimal total = ActHelper.sum((Act)this.getObject(), acts, (String)"total");
        this.visitTotal.setValue((Object)total);
        BigDecimal tax = ActHelper.sum((Act)this.getObject(), acts, (String)"tax");
        this.visitTax.setValue((Object)tax);
    }

    private class VisitChargeLayoutStrategy
    extends ChargeLayoutStrategy {
        VisitChargeLayoutStrategy() {
            super(VisitChargeEditor.this.getItems(), ChargeArchetypeNodesFactory.create().exclude(new String[]{"amount", "tax", "printed"}));
        }

        protected ComponentState createComponent(Property property, IMObject parent, LayoutContext context) {
            if ("status".equals(property.getName())) {
                return super.createComponent(this.createReadOnly(property), parent, context);
            }
            return super.createComponent(property, parent, context);
        }

        protected ComponentSet createComponentSet(IMObject object, List<Property> properties, LayoutContext context) {
            ComponentSet result = super.createComponentSet(object, properties, context);
            IMObjectComponentFactory factory = context.getComponentFactory();
            ComponentState total = factory.create((Property)VisitChargeEditor.this.visitTotal, object);
            ComponentState tax = factory.create((Property)VisitChargeEditor.this.visitTax, object);
            total.setDisplayName(Messages.get((String)"patient.record.charge.total"));
            tax.setDisplayName(Messages.get((String)"patient.record.charge.tax"));
            result.add(1, total);
            result.add(2, tax);
            return result;
        }
    }
}

