/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient;

import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.retry.AbstractRetryable;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class PatientMedicalRecordLinker
extends AbstractRetryable {
    private final MedicalRecordRules rules = (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class);
    private Act event;
    private Act problem;
    private Act item;
    private Act addendum;
    private static final Logger log = LoggerFactory.getLogger(PatientMedicalRecordLinker.class);

    public PatientMedicalRecordLinker(Act event, Act item) {
        boolean isProblem = TypeHelper.isA((IMObject)item, (String)"act.patientClinicalProblem");
        this.init(event, (Act)(isProblem ? item : null), isProblem ? null : item, null);
    }

    public PatientMedicalRecordLinker(Act event, Act problem, Act item) {
        this.init(event, problem, item, null);
    }

    public PatientMedicalRecordLinker(Act event, Act problem, Act item, Act addendum) {
        this.init(event, problem, item, addendum);
    }

    public String toString() {
        return "PatientMedicalRecordLinker(" + this.getId(this.event) + ", " + this.getId(this.item) + ")";
    }

    protected void link(Act currentEvent, Act currentProblem, Act currentItem, Act currentAddendum) {
        this.rules.linkMedicalRecords(currentEvent, currentProblem, currentItem, currentAddendum);
    }

    protected boolean runFirst() {
        return this.linkRecords(this.event, this.problem, this.item, this.addendum);
    }

    protected boolean runAction() {
        return this.linkRecords((Act)IMObjectHelper.reload((IMObject)this.event), (Act)IMObjectHelper.reload((IMObject)this.problem), (Act)IMObjectHelper.reload((IMObject)this.item), (Act)IMObjectHelper.reload((IMObject)this.addendum));
    }

    private void init(Act event, Act problem, Act item, Act addendum) {
        if (event != null) {
            if (!TypeHelper.isA((IMObject)event, (String)"act.patientClinicalEvent")) {
                throw new IllegalArgumentException("Argument 'event' is invalid: " + event.getArchetype());
            }
            if (event.isNew()) {
                throw new IllegalStateException("Argument 'event' must be saved");
            }
        }
        if (problem != null && problem.isNew()) {
            throw new IllegalStateException("Argument 'problem' must be saved");
        }
        if (item != null && item.isNew()) {
            throw new IllegalStateException("Argument 'item' must be saved: " + item.getArchetype());
        }
        if (addendum != null && addendum.isNew()) {
            throw new IllegalStateException("Argument 'addendum' must be saved: " + addendum.getArchetype());
        }
        this.event = event;
        this.problem = problem;
        this.item = item;
        this.addendum = addendum;
    }

    private boolean linkRecords(final Act currentEvent, final Act currentProblem, final Act currentItem, final Act currentAddendum) {
        boolean result = false;
        if (currentEvent == null && this.event != null) {
            this.logMissing(this.event);
        } else if (currentProblem == null && this.problem != null) {
            this.logMissing(this.problem);
        } else if (currentItem == null && this.item != null) {
            this.logMissing(this.item);
        } else if (currentAddendum == null && this.addendum != null) {
            this.logMissing(this.addendum);
        } else {
            TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    PatientMedicalRecordLinker.this.link(currentEvent, currentProblem, currentItem, currentAddendum);
                }
            });
            result = true;
        }
        return result;
    }

    private void logMissing(Act source) {
        log.warn("Cannot link " + this.getId(source) + ": it no longer exists");
    }

    private String getId(Act act) {
        if (act != null) {
            Reference ref = act.getObjectReference();
            return ref.getArchetype() + "-" + ref.getId();
        }
        return null;
    }
}

