/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient;

import java.util.List;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.RelationshipCollectionTargetEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.BreedEditor;

public class PatientLayoutStrategy
extends AbstractLayoutStrategy {
    private final RelationshipCollectionTargetEditor customFieldEditor;
    private final BreedEditor breedEditor;
    private IMObjectTabPaneModel tabModel;
    private ComponentState customFieldState;
    private int customFieldsTab;
    private boolean hideCustomFields;
    private static final ArchetypeNodes NO_CUSTOM_NODES = new ArchetypeNodes().exclude(new String[]{"customFields"});

    public PatientLayoutStrategy() {
        this(null, null);
    }

    public PatientLayoutStrategy(BreedEditor breedEditor, RelationshipCollectionTargetEditor customFieldEditor) {
        super(true);
        this.customFieldEditor = customFieldEditor;
        this.breedEditor = breedEditor;
    }

    public void removeCustomFields() {
        if (this.tabModel != null && this.customFieldsTab != -1) {
            this.tabModel.removeTabAt(this.customFieldsTab);
            this.customFieldsTab = -1;
        }
        if (this.customFieldState != null) {
            this.getFocusGroup().remove(this.customFieldState.getFocusGroup());
        }
        this.hideCustomFields = true;
    }

    public void addCustomFields() {
        this.hideCustomFields = false;
        if (this.customFieldState != null) {
            this.getFocusGroup().remove(this.customFieldState.getFocusGroup());
        }
        this.addTab(this.tabModel, this.customFieldEditor.getProperty(), this.createCustomEditorComponent(), true);
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        boolean show;
        this.customFieldsTab = -1;
        Property breed = properties.get("breed");
        Property newBreed = properties.get("newBreed");
        if (this.breedEditor != null) {
            this.addComponent(new ComponentState((PropertyEditor)this.breedEditor));
            show = this.breedEditor.isNewBreed();
        } else {
            boolean bl = show = StringUtils.isEmpty((CharSequence)breed.getString()) && !StringUtils.isEmpty((CharSequence)newBreed.getString());
        }
        if (show) {
            if (!context.isEdit()) {
                SimpleProperty copy = new SimpleProperty(breed);
                copy.setValue((Object)Messages.get((String)"patient.newbreed"));
                this.addComponent(this.createComponent((Property)copy, object, context));
            } else {
                this.addComponent(this.createComponent(newBreed, object, context));
            }
        }
        ArchetypeNodes nodes = this.hideCustomFields || !this.hasCustomFields(object) ? new ArchetypeNodes(NO_CUSTOM_NODES) : new ArchetypeNodes(DEFAULT_NODES);
        if (!show) {
            nodes.exclude(new String[]{"newBreed"});
        }
        this.setArchetypeNodes(nodes);
        return super.apply(object, properties, parent, context);
    }

    protected ComponentState createComponent(Property property, IMObject parent, LayoutContext context) {
        ComponentState result = "customFields".equals(property.getName()) ? (this.customFieldEditor != null ? this.createCustomEditorComponent() : this.createCustomViewComponent(property, parent, context)) : super.createComponent(property, parent, context);
        return result;
    }

    protected IMObjectTabPaneModel createTabModel(Component container) {
        this.tabModel = super.createTabModel(container);
        return this.tabModel;
    }

    protected void addTab(IMObjectTabPaneModel model, Property property, ComponentState component, boolean addShortcut) {
        super.addTab(model, property, component, addShortcut);
        if ("customFields".equals(property.getName())) {
            this.customFieldsTab = model.size() - 1;
        }
    }

    private ComponentState createCustomViewComponent(Property property, IMObject parent, LayoutContext context) {
        EntityRelationship relationship;
        Reference ref;
        ComponentState result = super.createComponent(property, parent, context);
        CollectionProperty collection = (CollectionProperty)property;
        List values = collection.getValues();
        if (!values.isEmpty() && (ref = (relationship = (EntityRelationship)values.get(0)).getTarget()) != null) {
            String displayName = this.getDisplayName(ref.getArchetype());
            result.setDisplayName(displayName);
        }
        return result;
    }

    private ComponentState createCustomEditorComponent() {
        Entity fields;
        String displayName = null;
        List objects = this.customFieldEditor.getObjects();
        Entity entity = fields = !objects.isEmpty() ? (Entity)objects.get(0) : null;
        if (fields != null) {
            displayName = this.getDisplayName((IMObject)fields);
        }
        this.customFieldState = new ComponentState(this.customFieldEditor.getComponent(), this.customFieldEditor.getProperty(), this.customFieldEditor.getFocusGroup(), displayName);
        return this.customFieldState;
    }

    private boolean hasCustomFields(IMObject object) {
        IMObjectBean bean = this.getBean(object);
        List relationships = bean.getTargets("customFields", EntityRelationship.class);
        return !relationships.isEmpty();
    }
}

