/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.comparators.TransformingComparator;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.SelectionHistory;
import org.openvpms.web.component.im.query.AbstractQuery;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.history.CustomerPatient;

public class CustomerPatientHistoryQuery
extends AbstractQuery<CustomerPatient> {
    private final List<CustomerPatient> history;
    private final Context context;
    private final PatientRules rules;
    private Component component;
    private final TextField filter;
    private final FocusGroup focusGroup = new FocusGroup(((Object)((Object)this)).getClass().getName());
    private static final String[] SHORT_NAMES = new String[]{"party.customer*", "party.patientpet"};

    public CustomerPatientHistoryQuery(SelectionHistory customers, SelectionHistory patients, Context context) {
        super(SHORT_NAMES, CustomerPatient.class);
        this.setAuto(true);
        this.context = context;
        this.rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
        this.history = this.getHistory(customers, patients);
        this.filter = TextComponentFactory.create();
        this.filter.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                CustomerPatientHistoryQuery.this.onQuery();
            }
        });
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = RowFactory.create((String)"ControlRow", (Component[])new Component[0]);
            Label nameLabel = LabelFactory.create((String)"query.search");
            this.component.add((Component)nameLabel);
            this.component.add((Component)this.filter);
            this.focusGroup.add((Component)this.filter);
        }
        return this.component;
    }

    public ResultSet<CustomerPatient> query(SortConstraint[] sort) {
        CustomerPatientResultSet resultSet = new CustomerPatientResultSet(this.history, this.getMaxResults());
        resultSet.sort(sort);
        String text = this.filter.getText();
        return !StringUtils.isEmpty((CharSequence)text) ? new MatchingResultSet((ResultSet<CustomerPatient>)resultSet, text) : resultSet;
    }

    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    public void setValue(String filter) {
        this.filter.setText(filter);
    }

    public boolean selects(Reference reference) {
        return false;
    }

    public BaseArchetypeConstraint.State getActive() {
        return BaseArchetypeConstraint.State.BOTH;
    }

    private List<CustomerPatient> getHistory(SelectionHistory customers, SelectionHistory patients) {
        ArrayList<CustomerPatient> result = new ArrayList<CustomerPatient>();
        HashSet allCustomers = new HashSet(customers.getSelections());
        HashSet allPatients = new HashSet(patients.getSelections());
        for (SelectionHistory.Selection selection : allPatients.toArray(new SelectionHistory.Selection[0])) {
            Party patient = (Party)selection.getObject();
            if (patient != null) {
                Reference customerRef = this.rules.getOwnerReference(patient);
                Party customer = (Party)IMObjectHelper.getObject((Reference)customerRef, (Context)this.context);
                Date patientSelect = selection.getTime();
                Date customerSelect = customer != null ? customers.getSelected((IMObject)customer) : null;
                Date selected = customerSelect != null ? (Date)ComparatorUtils.max((Object)customerSelect, (Object)patientSelect, null) : patientSelect;
                CustomerPatient pair = new CustomerPatient(customer, patient, selected);
                result.add(pair);
                if (customer != null) {
                    allCustomers.remove(new SelectionHistory.Selection(customerRef, this.context));
                }
            }
            allPatients.remove(selection);
        }
        for (SelectionHistory.Selection selection : allCustomers) {
            Party customer = (Party)selection.getObject();
            if (customer == null) continue;
            result.add(new CustomerPatient(customer, null, selection.getTime()));
        }
        for (SelectionHistory.Selection selection : allPatients) {
            Party patient = (Party)selection.getObject();
            if (patient == null) continue;
            result.add(new CustomerPatient(null, patient, selection.getTime()));
        }
        result.sort(Collections.reverseOrder(Comparator.comparing(CustomerPatient::getSelected)));
        return result;
    }

    private static class MatchingResultSet
    extends FilteredResultSet<CustomerPatient> {
        private final String match;

        public MatchingResultSet(ResultSet<CustomerPatient> set, String text) {
            super(set);
            this.match = text.toLowerCase();
        }

        protected void filter(CustomerPatient object, List<CustomerPatient> results) {
            if (this.matches(object.getCustomer()) || this.matches(object.getPatient())) {
                results.add(object);
            }
        }

        private boolean matches(Party party) {
            return party != null && (this.matches(party.getName()) || this.matches(party.getDescription()));
        }

        private boolean matches(String string) {
            return string != null && string.toLowerCase().contains(this.match);
        }
    }

    private static class CustomerPatientResultSet
    extends ListResultSet<CustomerPatient> {
        public CustomerPatientResultSet(List<CustomerPatient> objects, int pageSize) {
            super(objects, pageSize);
        }

        public void sort(SortConstraint[] sort) {
            if (sort != null && sort.length > 0 && sort[0] instanceof NodeSortConstraint) {
                this.sort((NodeSortConstraint)sort[0]);
            }
            super.sort(sort);
        }

        private void sort(NodeSortConstraint sort) {
            Comparator comparator = IMObjectSorter.getComparator((boolean)sort.isAscending());
            boolean customer = sort.getNodeName().equals("customer");
            TransformingComparator tc = new TransformingComparator((Transformer)new NameTransformer(customer), comparator);
            this.getObjects().sort(tc);
        }
    }

    private static class NameTransformer
    implements Transformer {
        private final boolean customer;

        public NameTransformer(boolean customer) {
            this.customer = customer;
        }

        public Object transform(Object input) {
            CustomerPatient selection = (CustomerPatient)input;
            Party party = this.customer ? selection.getCustomer() : selection.getPatient();
            return party != null ? party.getName() : null;
        }
    }
}

