/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.history;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.app.SelectionHistory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractQueryBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.history.CustomerPatient;
import org.openvpms.web.workspace.history.CustomerPatientHistoryQuery;

public class CustomerPatientHistoryBrowser
extends AbstractQueryBrowser<CustomerPatient> {
    public CustomerPatientHistoryBrowser(GlobalContext context, LayoutContext layout) {
        super((Query)CustomerPatientHistoryBrowser.createQuery(context), null, (IMTableModel)new HistoryModel((Context)context), layout);
    }

    public Party getSelectedParty() {
        return ((HistoryModel)this.getTableModel()).getSelectedParty();
    }

    protected PagedIMTable<CustomerPatient> createTable(IMTableModel<CustomerPatient> model) {
        PagedIMTable table = super.createTable(model);
        ((HistoryModel)model).setBrowser(this);
        return table;
    }

    private static CustomerPatientHistoryQuery createQuery(GlobalContext context) {
        SelectionHistory customers = context.getHistory("party.customer*");
        SelectionHistory patients = context.getHistory("party.patient*");
        return new CustomerPatientHistoryQuery(customers, patients, (Context)context);
    }

    private static class HistoryModel
    extends AbstractIMTableModel<CustomerPatient> {
        private final Context context;
        private CustomerPatientHistoryBrowser browser;
        private Party party;
        private static final int CUSTOMER_INDEX = 0;
        private static final int PATIENT_INDEX = 1;

        public HistoryModel(Context context) {
            this.context = context;
            DefaultTableColumnModel columns = new DefaultTableColumnModel();
            columns.addColumn(HistoryModel.createTableColumn((int)0, (String)"history.customer"));
            columns.addColumn(HistoryModel.createTableColumn((int)1, (String)"history.patient"));
            this.setTableColumnModel((TableColumnModel)columns);
        }

        public void setBrowser(CustomerPatientHistoryBrowser browser) {
            this.browser = browser;
        }

        public Party getSelectedParty() {
            return this.party;
        }

        protected Object getValue(CustomerPatient object, TableColumn column, int row) {
            Component result = null;
            switch (column.getModelIndex()) {
                case 0: {
                    result = this.getViewer(object, object.getCustomer());
                    break;
                }
                case 1: {
                    result = this.getViewer(object, object.getPatient());
                }
            }
            return result;
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            if (column == 0) {
                return new SortConstraint[]{new NodeSortConstraint("customer", ascending)};
            }
            if (column == 1) {
                return new SortConstraint[]{new NodeSortConstraint("patient", ascending)};
            }
            return null;
        }

        private Component getViewer(final CustomerPatient pair, final Party party) {
            if (party != null) {
                String name = party.getName();
                String description = party.getDescription();
                String text = name == null && description == null ? Messages.get((String)"imobject.none") : (description == null ? Messages.format((String)"imobject.name", (Object[])new Object[]{name}) : (name == null ? Messages.format((String)"imobject.description", (Object[])new Object[]{description}) : Messages.format((String)"imobject.summary", (Object[])new Object[]{name, description})));
                ActionListener listener = new ActionListener(){

                    public void onAction(ActionEvent e) {
                        party = party;
                        browser.setSelected(pair);
                        browser.notifySelected(pair);
                    }
                };
                IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(party.getObjectReference(), text, listener, this.context);
                return viewer.getComponent();
            }
            return null;
        }
    }
}

