/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.util.List;
import java.util.function.Consumer;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.delete.AsyncIMObjectDeletionListener;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.delete.IMObjectDeletionListener;
import org.openvpms.web.component.im.delete.SilentIMObjectDeleter;
import org.openvpms.web.component.im.edit.AbstractEditDialog;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorOperation;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveFailureFormatter;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.credit.CreditActEditDialog;
import org.openvpms.web.workspace.customer.payment.AbstractCustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.TransactionPaymentItemEditor;

public class CustomerPaymentEditDialog
extends CreditActEditDialog {
    public CustomerPaymentEditDialog(AbstractCustomerPaymentEditor editor, Context context) {
        super((IMObjectEditor)editor, context);
        this.init(editor);
    }

    public CustomerPaymentEditDialog(AbstractCustomerPaymentEditor editor, List<FinancialAct> debits, Context context) {
        super((IMObjectEditor)editor, debits, context);
        this.init(editor);
    }

    public AbstractCustomerPaymentEditor getEditor() {
        return (AbstractCustomerPaymentEditor)super.getEditor();
    }

    protected void onApply() {
        this.runProtected(editor -> {
            if (this.save() && editor.requiresTransaction()) {
                editor.processTransactions(() -> {});
            }
        });
    }

    protected void onOK() {
        this.runProtected(editor -> {
            if (this.save()) {
                if (editor.requiresTransaction()) {
                    editor.processTransactions(() -> {
                        TransactionPaymentItemEditor itemEditor = editor.getRequiresTransactionEditor();
                        if (itemEditor == null) {
                            this.onOK();
                        } else if (editor.postOnCompletion()) {
                            editor.makeSaveable();
                            ((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().title(this.getTitle())).messageKey("customer.payment.cannotPostWithOutstandingTxn", new Object[]{editor.getDisplayName(), itemEditor.getTransactionDisplayName()})).show();
                        } else if (this.save()) {
                            this.onOKCompleted();
                        }
                    });
                } else if (editor.postOnCompletion()) {
                    editor.setStatus("POSTED");
                    if (this.save()) {
                        this.onOKCompleted();
                    }
                } else {
                    this.onOKCompleted();
                }
            }
        });
    }

    protected void onOKCompleted() {
        this.close("ok");
    }

    private void init(AbstractCustomerPaymentEditor editor) {
        if (editor.isPosted() && editor.canChangeStatus()) {
            editor.makeSaveableAndPostOnCompletion();
        }
        this.setCancelListener(this::confirmCancel);
    }

    private void confirmCancel(Vetoable action) {
        if (this.canSave()) {
            AbstractCustomerPaymentEditor editor = this.getEditor();
            if ("IN_PROGRESS".equals(editor.getSavedStatus())) {
                if (editor.canDelete() && editor.isEmptyOrOnlyHasTransactionItems()) {
                    ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"editor.cancel.title"))).message(Messages.format((String)"customer.payment.cancel.delete", (Object[])new Object[]{editor.getDisplayName()}))).yesNoCancel()).yes(true, () -> this.delete(action, editor))).no(() -> action.veto(false))).cancel(() -> action.veto(true))).show();
                } else {
                    ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"editor.cancel.title"))).message(Messages.format((String)"customer.payment.cancel.unfinalised", (Object[])new Object[]{editor.getDisplayName()}))).yesNo()).yes(() -> action.veto(false))).no(() -> action.veto(true))).show();
                }
            } else {
                action.veto(false);
            }
        } else {
            action.veto(false);
        }
    }

    private void delete(final Vetoable action, final AbstractCustomerPaymentEditor editor) {
        IMObjectDeletionHandlerFactory factory = (IMObjectDeletionHandlerFactory)ServiceHelper.getBean(IMObjectDeletionHandlerFactory.class);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        SilentIMObjectDeleter deleter = new SilentIMObjectDeleter(factory, (ArchetypeService)service);
        AsyncIMObjectDeletionListener<IMObject> listener = new AsyncIMObjectDeletionListener<IMObject>(){

            protected void completed() {
                action.veto(false);
            }

            protected void failed() {
                CustomerPaymentEditDialog.this.reload((IMObjectEditor)editor);
                action.veto(true);
            }
        };
        deleter.delete((IMObject)editor.getObject(), this.getContext(), editor.getHelpContext(), (IMObjectDeletionListener)listener);
    }

    private void runProtected(final Consumer<AbstractCustomerPaymentEditor> consumer) {
        AbstractEditDialog.ReloadingEditorOperation<AbstractCustomerPaymentEditor> operation = new AbstractEditDialog.ReloadingEditorOperation<AbstractCustomerPaymentEditor>((AbstractIMObjectEditorOperation.FailureFormatter)new SaveFailureFormatter()){

            public void apply(AbstractCustomerPaymentEditor editor) {
                consumer.accept(editor);
            }
        };
        AbstractCustomerPaymentEditor editor = this.getEditor();
        try {
            operation.apply((IMObjectEditor)editor);
        }
        catch (Throwable exception) {
            operation.failed((IMObjectEditor)editor, exception, null);
        }
    }
}

