/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.order.OrderInvoicer;
import org.openvpms.web.workspace.patient.investigation.PatientInvestigationActEditor;

public class InvestigationOrderInvoicer
extends OrderInvoicer {
    public InvestigationOrderInvoicer(FinancialAct act, User clinician, OrderRules rules, IArchetypeService service) {
        super(act, clinician, rules, service);
    }

    @Override
    public boolean requiresEdit() {
        return true;
    }

    @Override
    protected OrderInvoicer.Item createItem(FinancialAct item, boolean ordered, FinancialAct invoiceItem, FinancialAct invoice) {
        return new InvestigationItem(item, ordered, invoiceItem, invoice);
    }

    private class InvestigationItem
    extends OrderInvoicer.Item {
        private final Reference investigation;

        public InvestigationItem(FinancialAct orderItem, boolean ordered, FinancialAct invoiceItem, FinancialAct invoice) {
            super(InvestigationOrderInvoicer.this, orderItem, ordered, invoiceItem, invoice);
            IMObjectBean bean = InvestigationOrderInvoicer.this.getBean((IMObject)orderItem);
            this.investigation = bean.getReference("sourceInvestigation");
        }

        @Override
        public boolean canInvoice() {
            return !this.isOrder() && !this.isPosted() && this.getInvoiceItem() != null;
        }

        @Override
        public boolean canCredit() {
            return false;
        }

        @Override
        public boolean validate(Validator validator) {
            return super.validate(validator) && this.validateRequired(validator, "sourceInvestigation", this.investigation);
        }

        @Override
        public void charge(CustomerChargeActEditor editor, CustomerChargeActItemEditor itemEditor) {
            PatientInvestigationActEditor investigation;
            if (!this.isOrder() && (investigation = itemEditor.getInvestigation(this.investigation)) != null) {
                investigation.setStatus("CANCELLED");
            }
        }
    }
}

