/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextArea;

public class EstimateLayoutStrategy
extends AbstractLayoutStrategy {
    private static final ArchetypeNodes NODES = new ArchetypeNodes().exclude(new String[]{"lowTotal", "highTotal", "notes"});

    public EstimateLayoutStrategy() {
        super(NODES);
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property lowTotal = properties.get("lowTotal");
        Property highTotal = properties.get("highTotal");
        this.addComponent(this.createComponent(lowTotal, object, context));
        this.addComponent(this.createComponent(highTotal, object, context));
        this.addComponent(this.createNotes(object, properties, context));
        return super.apply(object, properties, parent, context);
    }

    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        ComponentGrid grid = this.createGrid(object, properties, context);
        this.addAuditInfo(object, grid, context);
        grid.add(this.getComponent("notes"), 2);
        grid.add(new ComponentState[]{this.getComponent("lowTotal"), this.getComponent("highTotal")});
        Grid component = this.createGrid(grid);
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{component}));
    }

    private ComponentState createNotes(IMObject object, PropertySet properties, LayoutContext context) {
        ComponentState notes = this.createComponent(properties.get("notes"), object, context);
        Component component = notes.getComponent();
        if (component instanceof TextArea) {
            TextArea text = (TextArea)component;
            text.setHeight(new Extent(5, 64));
            text.setWidth(Styles.FULL_WIDTH);
        }
        return notes;
    }
}

