/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.TemplateProductListener;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.charge.AbstractInvoicer;
import org.openvpms.web.workspace.customer.charge.ChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.patient.charge.TemplateChargeItems;

public class EstimateInvoicer
extends AbstractInvoicer {
    public CustomerChargeActEditDialog invoice(Act estimate, FinancialAct invoice, LayoutContext context) {
        estimate.setStatus("INVOICED");
        IMObjectBean estimateBean = this.getBean((IMObject)estimate);
        if (invoice == null) {
            invoice = this.createInvoice(estimateBean.getTargetRef("customer"));
        }
        estimateBean.addTarget("invoice", (IMObject)invoice, "estimates");
        CustomerChargeActEditor editor = this.createChargeEditor(invoice, context);
        AbstractInvoicer.ChargeDialog dialog = new AbstractInvoicer.ChargeDialog(editor, estimate, context.getContext());
        dialog.show();
        this.invoice(estimate, editor, context);
        return dialog;
    }

    public void invoice(Act estimate, CustomerChargeActEditor editor, LayoutContext context) {
        InvoicingStrategy strategy = this.createStrategy(estimate, editor, context);
        strategy.invoice();
    }

    protected InvoicingStrategy createStrategy(Act estimate, CustomerChargeActEditor editor, LayoutContext context) {
        return new InvoicingStrategy(estimate, editor, context);
    }

    private static class ServiceRatioDialog
    extends ModalDialog {
        private final List<CustomerChargeActItemEditor> editors;
        private final List<BigDecimal> ratios = new ArrayList<BigDecimal>();
        private final PagedIMTable<Act> table;
        private final Model model;
        private final RadioButton estimate;
        private final RadioButton current;

        public ServiceRatioDialog(List<CustomerChargeActItemEditor> editors, LayoutContext context) {
            super(Messages.get((String)"customer.estimate.serviceratio.title"), "MediumWidthHeightDialog", OK, context.getHelpContext());
            this.editors = editors;
            HashMap<Act, CustomerChargeActItemEditor> map = new HashMap<Act, CustomerChargeActItemEditor>();
            for (CustomerChargeActItemEditor editor : editors) {
                this.ratios.add(editor.getServiceRatio());
                map.put((Act)editor.getObject(), editor);
            }
            ArrayList acts = new ArrayList(map.keySet());
            this.model = new Model(map, context);
            this.table = new PagedIMTable((IMTableModel)this.model);
            this.table.setResultSet((ResultSet)new ListResultSet(acts, 25));
            ButtonGroup group = new ButtonGroup();
            this.estimate = ButtonFactory.create((String)"customer.estimate.serviceratio.estimateprice", (ButtonGroup)group, this::useEstimateServiceRatios);
            this.current = ButtonFactory.create((String)"customer.estimate.serviceratio.currentprice", (ButtonGroup)group, this::useCurrentRatios);
            this.enableOK();
        }

        protected void doLayout() {
            Label content = LabelFactory.create((boolean)true, (boolean)true);
            content.setText(Messages.get((String)"customer.estimate.serviceratio.message"));
            Label prompt = LabelFactory.create((String)"customer.estimate.serviceratio.prompt");
            Column buttons = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{prompt, this.estimate, this.current});
            Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{content, buttons, this.table.getComponent()});
            this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
        }

        private void useEstimateServiceRatios() {
            for (int i = 0; i < this.editors.size(); ++i) {
                CustomerChargeActItemEditor editor = this.editors.get(i);
                BigDecimal ratio = this.ratios.get(i);
                editor.setServiceRatio(ratio);
            }
            this.refresh();
        }

        private void useCurrentRatios() {
            for (CustomerChargeActItemEditor editor : this.editors) {
                editor.setServiceRatio(editor.getAvailableServiceRatio());
            }
            this.refresh();
        }

        private void refresh() {
            this.model.fireTableDataChanged();
            this.enableOK();
        }

        private void enableOK() {
            this.getButtons().setEnabled("ok", this.estimate.isSelected() || this.current.isSelected());
        }

        private static class Model
        extends DefaultDescriptorTableModel<Act> {
            private final Map<Act, CustomerChargeActItemEditor> editors;
            private final int ratioIndex;
            private final int availableRatioIndex;

            public Model(Map<Act, CustomerChargeActItemEditor> editors, LayoutContext context) {
                super("act.customerAccountInvoiceItem", context, new String[]{"product", "quantity", "total"});
                this.editors = editors;
                DefaultTableColumnModel model = (DefaultTableColumnModel)this.getColumnModel();
                this.ratioIndex = this.getNextModelIndex((TableColumnModel)model);
                this.availableRatioIndex = this.ratioIndex + 1;
                model.addColumn(Model.createTableColumn((int)this.ratioIndex, (String)"customer.estimate.serviceratio.current"));
                model.addColumn(Model.createTableColumn((int)this.availableRatioIndex, (String)"customer.estimate.serviceratio.new"));
            }

            protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
                return super.createColumnModel(archetypes, context);
            }

            protected Object getValue(Act object, TableColumn column, int row) {
                CustomerChargeActItemEditor editor;
                BigDecimal ratio;
                int index = column.getModelIndex();
                Object result = index == this.ratioIndex ? ((ratio = (editor = this.editors.get(object)).getServiceRatio()) != null ? ratio : Messages.get((String)"customer.estimate.serviceratio.none")) : (index == this.availableRatioIndex ? ((ratio = (editor = this.editors.get(object)).getAvailableServiceRatio()) != null ? ratio : Messages.get((String)"customer.estimate.serviceratio.none")) : super.getValue((IMObject)object, column, row));
                return result;
            }
        }
    }

    protected class InvoicingStrategy {
        private final Act estimate;
        private final CustomerChargeActEditor editor;
        private final LayoutContext context;
        private final Map<Product, List<Act>> templateItems = new HashMap<Product, List<Act>>();
        private final Map<Integer, Integer> groups = new HashMap<Integer, Integer>();

        public InvoicingStrategy(Act estimate, CustomerChargeActEditor editor, LayoutContext context) {
            this.estimate = estimate;
            this.editor = editor;
            this.context = context;
        }

        public void invoice() {
            AlertListener listener;
            ActRelationshipCollectionEditor documents;
            ActRelationshipCollectionEditor customerNotes;
            IMObjectBean bean = EstimateInvoicer.this.getBean((IMObject)this.estimate);
            ChargeItemRelationshipCollectionEditor items = this.getItems();
            ArrayList<CustomerChargeActItemEditor> ratios = new ArrayList<CustomerChargeActItemEditor>();
            int outOfStock = 0;
            List acts = bean.getTargets("items", Act.class, Policies.orderBySequence());
            for (Object estimationItem : acts) {
                BigDecimal actual;
                BigDecimal available;
                CustomerChargeActItemEditor itemEditor = this.invoice((Act)estimationItem);
                if (itemEditor == null) continue;
                BigDecimal stock = itemEditor.getStock();
                if (stock != null && stock.compareTo(BigDecimal.ZERO) <= 0) {
                    ++outOfStock;
                }
                if (Objects.equals(available = itemEditor.getAvailableServiceRatio(), actual = itemEditor.getServiceRatio())) continue;
                ratios.add(itemEditor);
            }
            items.refresh();
            if (!this.templateItems.isEmpty()) {
                this.notifyTemplateExpansion(this.templateItems);
            }
            if ((customerNotes = this.editor.getCustomerNotes()) != null) {
                for (Act note : bean.getTargets("customerNotes", Act.class)) {
                    IMObjectEditor noteEditor = customerNotes.getEditor((IMObject)note);
                    noteEditor.getComponent();
                    customerNotes.addEdited(noteEditor);
                }
            }
            if ((documents = this.editor.getDocuments()) != null) {
                for (Act document : bean.getTargets("documents", Act.class)) {
                    IMObjectEditor documentsEditor = documents.getEditor((IMObject)document);
                    documentsEditor.getComponent();
                    documents.addEdited(documentsEditor);
                }
            }
            if (!ratios.isEmpty()) {
                this.editor.getEditorQueue().queue((PopupDialog)new ServiceRatioDialog(ratios, this.context));
            }
            if (outOfStock != 0 && (listener = this.editor.getAlertListener()) != null) {
                listener.onAlert(Messages.format((String)"customer.charge.outofstock", (Object[])new Object[]{outOfStock}));
            }
        }

        protected CustomerChargeActItemEditor invoice(Act item) {
            IMObjectBean itemBean = EstimateInvoicer.this.getBean((IMObject)item);
            CustomerChargeActItemEditor itemEditor = EstimateInvoicer.this.getItemEditor(this.editor);
            itemEditor.setPatientRef(itemBean.getTargetRef("patient"));
            itemEditor.setMinimumQuantity(itemBean.getBigDecimal("lowQty"));
            Reference templateRef = null;
            int group = -1;
            Participation participation = (Participation)itemBean.getObject("template", Participation.class);
            if (participation != null) {
                templateRef = participation.getEntity();
                IMObjectBean participationBean = EstimateInvoicer.this.getBean((IMObject)participation);
                if (templateRef != null) {
                    int estimateGroup = participationBean.getInt("group");
                    Integer invoiceGroup = this.groups.get(estimateGroup);
                    if (invoiceGroup == null) {
                        invoiceGroup = this.getItems().getNextTemplateGroup();
                        this.groups.put(estimateGroup, invoiceGroup);
                    }
                    group = invoiceGroup;
                }
            }
            Reference product = itemBean.getTargetRef("product");
            this.setProduct(itemEditor, product, templateRef, group);
            itemEditor.setPrint(itemBean.getBoolean("print", true));
            itemEditor.setServiceRatio(itemBean.getBigDecimal("serviceRatio"));
            itemEditor.setQuantity(itemBean.getBigDecimal("highQty"));
            itemEditor.setFixedPrice(itemBean.getBigDecimal("fixedPrice"));
            itemEditor.setUnitPrice(itemBean.getBigDecimal("highUnitPrice"));
            itemEditor.setDiscount(itemBean.getBigDecimal("highDiscount"));
            return itemEditor;
        }

        protected void setProduct(CustomerChargeActItemEditor itemEditor, Reference productRef, Reference templateRef, int group) {
            itemEditor.setProduct(productRef, templateRef, group);
            Product template = itemEditor.getTemplate();
            if (template != null) {
                List items = this.templateItems.computeIfAbsent(template, k -> new ArrayList());
                items.add(itemEditor.getObject());
            }
        }

        protected void notifyTemplateExpansion(Map<Product, List<Act>> items) {
            List<TemplateChargeItems> templates = this.getItems().getTemplates();
            for (Map.Entry<Product, List<Act>> entry : items.entrySet()) {
                Product template = entry.getKey();
                List<Act> acts = entry.getValue();
                templates.add(new TemplateChargeItems(template, acts));
            }
            TemplateProductListener listener = this.getItems().getTemplateProductListener();
            if (listener != null) {
                for (Map.Entry<Product, List<Act>> entry : items.entrySet()) {
                    listener.expanded(entry.getKey());
                }
            }
        }

        protected ChargeItemRelationshipCollectionEditor getItems() {
            return this.editor.getItems();
        }
    }
}

