/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategyFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupFilter;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.estimate.EstimateActRelationshipCollectionEditor;

public class EstimateEditor
extends ActEditor {
    private static final Log log = LogFactory.getLog(EstimateEditor.class);

    public EstimateEditor(Act act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        if (!TypeHelper.isA((IMObject)act, (String)"act.customerEstimation")) {
            throw new IllegalArgumentException("Invalid act type:" + act.getArchetype());
        }
        if (act.isNew() && act.getActivityStartTime() != null && act.getActivityEndTime() == null) {
            PracticeRules rules = (PracticeRules)ServiceHelper.getBean(PracticeRules.class);
            Date estimateExpiryDate = rules.getEstimateExpiryDate(act.getActivityStartTime(), context.getContext().getPractice());
            this.setEndTime(estimateExpiryDate);
        }
        this.addStartEndTimeListeners();
        this.initLocation();
        this.initParticipant("customer", (IMObject)context.getContext().getCustomer());
        this.getItems().setTemplateProductListener(this::templateProductExpanded);
    }

    public ActRelationshipCollectionEditor getItems() {
        return super.getItems();
    }

    public ActRelationshipCollectionEditor getCustomerNotes() {
        return (ActRelationshipCollectionEditor)this.getEditors().getEditor("customerNotes");
    }

    public ActRelationshipCollectionEditor getDocuments() {
        return (ActRelationshipCollectionEditor)this.getEditors().getEditor("documents");
    }

    protected Party initLocation() {
        Context context = this.getLayoutContext().getContext();
        Party location = context.getLocation();
        Party stockLocation = null;
        if (location != null) {
            LocationRules rules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
            stockLocation = rules.getDefaultStockLocation(location);
        }
        context.setStockLocation(stockLocation);
        return location;
    }

    protected ActRelationshipCollectionEditor createItemsEditor(Act act, CollectionProperty items) {
        return new EstimateActRelationshipCollectionEditor(items, act, this.getLayoutContext());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategyFactory layoutStrategy = this.getLayoutContext().getLayoutStrategyFactory();
        IMObjectLayoutStrategy strategy = layoutStrategy.create((IMObject)this.getObject(), this.getParent());
        Property status = this.getProperty("status");
        NodeLookupQuery query = new NodeLookupQuery((IMObject)this.getObject(), status);
        query = new LookupFilter((LookupQuery)query, false, new String[]{"INVOICED"});
        LookupField field = LookupFieldFactory.create((Property)status, (LookupQuery)query);
        strategy.addComponent(new ComponentState((Component)field, status));
        strategy.addComponent(new ComponentState((PropertyEditor)this.getItems()));
        return strategy;
    }

    protected void onItemsChanged() {
        Property highTotal = this.getProperty("highTotal");
        Property lowTotal = this.getProperty("lowTotal");
        List acts = this.getItems().getCurrentActs();
        BigDecimal low = this.calculateTotal(acts, "lowTotal");
        BigDecimal high = this.calculateTotal(acts, "highTotal");
        lowTotal.setValue((Object)low);
        highTotal.setValue((Object)high);
    }

    protected void onStartTimeChanged() {
        Date start = this.getStartTime();
        if (start != null) {
            Date now = new Date();
            if (DateRules.compareDates((Date)start, (Date)now) < 0) {
                this.setStartTime(now, true);
            } else {
                Date end = this.getEndTime();
                if (end != null && end.compareTo(start) < 0) {
                    this.setEndTime(start, true);
                }
            }
        }
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateAmounts(validator);
    }

    protected boolean validateAmounts(Validator validator) {
        List acts = this.getItems().getActs();
        return this.validateTotal(validator, acts, "lowTotal") && this.validateTotal(validator, acts, "highTotal");
    }

    protected void templateProductExpanded(Product product) {
        IMObjectBean bean = this.getBean((IMObject)this.getObject());
        if (bean.isDefaultValue("title")) {
            this.getProperty("title").setValue((Object)product.getName());
        }
    }

    private boolean validateTotal(Validator validator, List<Act> acts, String node) {
        boolean result;
        BigDecimal sum = this.calculateTotal(acts, node);
        Property property = this.getProperty(node);
        BigDecimal total = property.getBigDecimal(BigDecimal.ZERO);
        boolean bl = result = total.compareTo(sum) == 0;
        if (!result) {
            String message = Messages.format((String)"act.validation.totalMismatch", (Object[])new Object[]{property.getDisplayName(), NumberFormatter.formatCurrency((Number)total), this.getItems().getProperty().getDisplayName(), NumberFormatter.formatCurrency((Number)sum)});
            validator.add((Modifiable)this, new ValidatorError(message));
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
                User user = this.getLayoutContext().getContext().getUser();
                String userName = user != null ? user.getUsername() : null;
                log.warn((Object)("username = " + userName + ", act = " + this.getObject()));
                for (int i = 0; i < acts.size(); ++i) {
                    log.warn((Object)("act item (" + (i + 1) + " of " + acts.size() + ") = " + acts.get(i)));
                }
                IMObjectEditor current = this.getItems().getCurrentEditor();
                if (current != null) {
                    log.warn((Object)("current act item = " + current.getObject()));
                }
            }
        }
        return result;
    }

    private BigDecimal calculateTotal(List<Act> acts, String node) {
        return ActHelper.sum((Act)this.getObject(), acts, (String)node);
    }
}

