/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.RemoveConfirmationHandler;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.AbstractChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.ChargeEditContext;
import org.openvpms.web.workspace.customer.charge.DefaultChargeRemoveConfirmationHandler;
import org.openvpms.web.workspace.customer.estimate.EstimateItemEditor;

public class EstimateActRelationshipCollectionEditor
extends AbstractChargeItemRelationshipCollectionEditor {
    public EstimateActRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
        super(property, act, context, EstimateActRelationshipCollectionEditor.createEditContext(act, context));
        this.setRemoveConfirmationHandler((RemoveConfirmationHandler)new DefaultChargeRemoveConfirmationHandler(context.getContext(), context.getHelpContext()));
    }

    public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        return this.initialiseEditor(new EstimateItemEditor((Act)object, (Act)this.getObject(), this.getEditContext(), context));
    }

    protected IMObjectEditor initialiseEditor(EstimateItemEditor editor) {
        editor.setProductListener(this.getProductListener());
        return editor;
    }

    @Override
    protected ChargeEditContext getEditContext() {
        return (ChargeEditContext)super.getEditContext();
    }

    private static ChargeEditContext createEditContext(Act act, LayoutContext context) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
        Party customer = (Party)IMObjectHelper.getObject((Reference)bean.getTargetRef("customer"), (Context)context.getContext());
        if (customer == null) {
            throw new IllegalStateException(act.getArchetype() + " has no customer");
        }
        Party location = context.getContext().getLocation();
        return new ChargeEditContext(customer, location, context);
    }
}

