/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.web.system.ServiceHelper;

public class CustomerEstimates {
    public List<Act> getEstimates(Party customer, Party patient) {
        ArchetypeQuery query = this.createQuery(customer, patient);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator((IArchetypeQuery)query);
        ArrayList<Act> list = new ArrayList<Act>();
        while (iterator.hasNext()) {
            list.add((Act)iterator.next());
        }
        return list;
    }

    public boolean hasEstimates(Party customer, Party patient) {
        ArchetypeQuery query = this.createQuery(customer, patient);
        query.setCountResults(true);
        return ServiceHelper.getArchetypeService().get((IArchetypeQuery)query).getTotalResults() != 0;
    }

    private ArchetypeQuery createQuery(Party customer, Party patient) {
        ArchetypeQuery query = new ArchetypeQuery("act.customerEstimation");
        query.setDistinct(true);
        query.add((IConstraint)Constraints.join((String)"customer").add((IConstraint)Constraints.eq((String)"entity", (Object)customer)));
        query.add((IConstraint)Constraints.ne((String)"status", (Object)"CANCELLED"));
        query.add((IConstraint)Constraints.ne((String)"status", (Object)"INVOICED"));
        query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.isNull((String)"endTime"), Constraints.gt((String)"endTime", (Object)new Date())}));
        if (patient != null) {
            query.add((IConstraint)Constraints.join((String)"items").add((IConstraint)Constraints.join((String)"target").add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.eq((String)"entity", (Object)patient)))));
        }
        return query;
    }
}

